/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.provider;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.BaseColumns;
import java.util.HashMap;
import th.or.nectec.android.library.database.sqlite.SQLiteCreateBuilder;
import th.or.nectec.android.library.provider.columns.AddressColumns;
import th.or.nectec.android.library.provider.columns.NameColumn;
import th.or.nectec.android.library.util.JSONInsertOrUpdateTask;

public class NTTable {

    public static class SyncTable {
        public static final String TABLENAME = "_sync";
        public static final String NAME = "name";
        public static final String UPDATE_TIME = "update_time";
        public static final Uri CONTENT_URI = Uri.parse((String)"content://th.or.nectec.android.provider.NTProvider/system/sync");
        public static final String CONTENT_DIR_TYPE = "vnd.android.cursor.dir/vnd.th.or.nectec.android.provider.NTProvider.system.sync";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.th.or.nectec.android.provider.NTProvider.system.sync";
        public static final HashMap<String, String> PROJECTION_MAP;
        public static final String CREATE_SQL;
        public static final String DEFAULT_TIMESTAMP = "0000-00-00 00:00:00";

        public static String getLastUpdateTime(Context context, String name) {
            Cursor c = context.getContentResolver().query(CONTENT_URI, new String[]{UPDATE_TIME}, "name=?", new String[]{name}, null);
            if (c.moveToFirst()) {
                return c.getString(0);
            }
            ContentValues cv = new ContentValues();
            cv.put(NAME, name);
            cv.put(UPDATE_TIME, DEFAULT_TIMESTAMP);
            context.getContentResolver().insert(CONTENT_URI, cv);
            return DEFAULT_TIMESTAMP;
        }

        static {
            SQLiteCreateBuilder sb = new SQLiteCreateBuilder(TABLENAME);
            sb.addTextColumns(NAME, UPDATE_TIME);
            sb.addPrimaryKey(NAME);
            CREATE_SQL = sb.build();
            PROJECTION_MAP = sb.buildProjectionMap();
        }
    }

    public static class RefPrename
    implements BaseColumns,
    NameColumn {
        public static final String TABLENAME = "RefPrename";
        public static final String CODE = "prename_code";
        public static final String PRENAME = "prename";
        public static final String PRENAME_FULL = "prename_full";
        public static final String GENDER = "gender";
        public static final String STATUS = "status";
        public static final String UPDATE_TIME = "update_time";
        public static final Uri CONTENT_URI = Uri.parse((String)"content://th.or.nectec.android.provider.NTProvider/ref/prename");
        public static final String CONTENT_DIR_TYPE = "vnd.android.cursor.dir/vnd.th.or.nectec.android.provider.NTProvider.ref.prename";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.th.or.nectec.android.provider.NTProvider.ref.prename";
        public static final HashMap<String, String> PROJECTION_MAP;
        public static final JSONInsertOrUpdateTask.Params JSON_PARAM;
        public static final String CREATE_SQL;

        static {
            SQLiteCreateBuilder builder = new SQLiteCreateBuilder(TABLENAME);
            builder.addTextColumns(CODE, PRENAME, PRENAME_FULL, GENDER, STATUS, UPDATE_TIME);
            builder.addPrimaryKey(CODE);
            builder.addUNIQUE(PRENAME, PRENAME_FULL);
            CREATE_SQL = builder.build();
            PROJECTION_MAP = builder.buildProjectionMap();
            PROJECTION_MAP.put("_id", "prename_code as _id");
            PROJECTION_MAP.put("name", "prename as name");
            JSON_PARAM = new JSONInsertOrUpdateTask.Params();
            RefPrename.JSON_PARAM.tablename = TABLENAME;
            RefPrename.JSON_PARAM.uri = CONTENT_URI;
            RefPrename.JSON_PARAM.strColumn = new String[]{CODE, PRENAME, PRENAME_FULL, STATUS, UPDATE_TIME};
            RefPrename.JSON_PARAM.whereCause = "prename_code=?";
            RefPrename.JSON_PARAM.argsColumn = new String[]{CODE};
        }
    }

    public static class RefAddress
    implements AddressColumns {
        public static final String TABLENAME = "RefAddress";
        public static final String UPDATE_TIME = "update_time";
        public static final Uri CONTENT_URI = Uri.parse((String)"content://th.or.nectec.android.provider.NTProvider/ref/address");
        public static final String CONTENT_DIR_TYPE = "vnd.android.cursor.dir/vnd.th.or.nectec.android.provider.NTProvider.ref.address";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.th.or.nectec.android.provider.NTProvider.ref.address";
        public static final HashMap<String, String> PROJECTION_MAP;
        public static final String CREATE_SQL;
        public static final JSONInsertOrUpdateTask.Params JSON_PARAM;

        static {
            SQLiteCreateBuilder builder = new SQLiteCreateBuilder(TABLENAME);
            builder.addTextColumn("address_code", new String[]{"PRIMARY KEY"});
            builder.addTextColumns("province", "district", "subdistrict", UPDATE_TIME);
            builder.addUNIQUE("province", "district", "subdistrict");
            CREATE_SQL = builder.build();
            PROJECTION_MAP = builder.buildProjectionMap();
            JSON_PARAM = new JSONInsertOrUpdateTask.Params();
            RefAddress.JSON_PARAM.tablename = TABLENAME;
            RefAddress.JSON_PARAM.uri = CONTENT_URI;
            RefAddress.JSON_PARAM.strColumn = new String[]{"address_code", "subdistrict", "district", "province", UPDATE_TIME};
            RefAddress.JSON_PARAM.whereCause = "address_code=?";
            RefAddress.JSON_PARAM.argsColumn = new String[]{"address_code"};
        }
    }
}

