/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.network;

import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpAsyncTask
extends AsyncTask<Request, Response, ArrayList<Response>> {
    public static final String TAG = "PostTask";
    public static final int TIME_OUT = 30000;
    public static final int SLEEP_TIME = 500;
    private TaskCallBack mCallback;
    private int maxAttempt = 3;

    public HttpAsyncTask(TaskCallBack callback) {
        this.mCallback = callback;
    }

    public void setMaxAttempt(int maxAttempt) {
        if (maxAttempt < 1) {
            maxAttempt = 1;
        }
        if (maxAttempt > 10) {
            maxAttempt = 10;
        }
        this.maxAttempt = maxAttempt;
    }

    protected ArrayList<Response> doInBackground(Request ... request) {
        ArrayList<Response> resList = new ArrayList<Response>();
        block4: for (Request req : request) {
            Response res = new Response();
            for (int i = 0; i < this.maxAttempt; ++i) {
                try {
                    Log.e((String)TAG, (String)("HTTP TASK :" + req.url + "&attempt=" + (i + 1)));
                    HttpAsyncTask.connect(req, res);
                    resList.add(res);
                    this.publishProgress(new Response[]{res});
                    Thread.sleep(500L);
                    continue block4;
                }
                catch (SocketTimeoutException se) {
                    Log.e((String)TAG, (String)"Socket Timeout");
                    continue;
                }
                catch (IOException io) {
                    Log.e((String)TAG, (String)"IO error on PostTask", (Throwable)io);
                    io.printStackTrace();
                    res.status = 10;
                    this.publishProgress(new Response[]{res});
                    continue block4;
                }
                catch (InterruptedException e) {
                    Log.e((String)TAG, (String)"Interrupted error on PostTask", (Throwable)e);
                    e.printStackTrace();
                    continue block4;
                }
            }
        }
        return resList;
    }

    private static String connect(Request request, Response res) throws IOException, SocketTimeoutException {
        String line;
        String message;
        URL url;
        StringBuilder bodyBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = request.params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> params = iterator.next();
            bodyBuilder.append(params.getKey()).append('=').append(params.getValue());
            if (!iterator.hasNext()) continue;
            bodyBuilder.append('&');
        }
        String body = bodyBuilder.toString();
        String endpoint = request.url;
        try {
            if (request.method.equals("GET") && body.length() > 0) {
                endpoint = endpoint + "?" + body;
            }
            url = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid url: " + endpoint);
        }
        Log.v((String)TAG, (String)("Requesting '" + request.method + "" + body + "' to " + url));
        byte[] bytes = body.getBytes();
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        conn.setUseCaches(false);
        conn.setRequestMethod(request.method);
        if (request.method.equals("POST")) {
            conn.setDoOutput(true);
            conn.setFixedLengthStreamingMode(bytes.length);
            OutputStream out = conn.getOutputStream();
            out.write(bytes);
            out.close();
        }
        int status = conn.getResponseCode();
        res.msg = message = conn.getResponseMessage();
        res.status = status;
        if (status != 200) {
            throw new IOException("Request failed with error code=" + status + ", msg=" + conn.getResponseMessage());
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            if (TextUtils.isEmpty((CharSequence)(line = line.trim()))) continue;
            res.data = !TextUtils.isEmpty((CharSequence)res.data) ? res.data + line : line;
            Log.i((String)TAG, (String)("RES Message: " + line));
        }
        rd.close();
        conn.disconnect();
        res.url = request.url;
        return line;
    }

    protected void onProgressUpdate(Response ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.mCallback != null) {
            Log.d((String)TAG, (String)"on Progress Update");
            if (values[0].status == 10) {
                this.mCallback.onIOException();
                Log.d((String)TAG, (String)"IOException called");
            } else {
                this.mCallback.onProgressUpdate(values);
            }
        }
    }

    protected void onPostExecute(ArrayList<Response> result) {
        super.onPostExecute(result);
        if (this.mCallback != null) {
            this.mCallback.onPostExecute(result);
        }
    }

    public static class Response {
        public String url;
        public int status = 404;
        public String msg;
        public String data;

        public String toString() {
            return "Response [url=" + this.url + ", status=" + this.status + ", msg=" + this.msg + ", data=" + this.data + "]";
        }
    }

    public static class Request {
        public static final String METHOD_DELETE = "DELETE";
        public static final String METHOD_GET = "GET";
        public static final String METHOD_POST = "POST";
        public static final String METHOD_PUT = "PUT";
        public String url;
        public String method;
        public Map<String, String> params;

        public Request(String endpoint, String method) {
            this.url = endpoint;
            this.method = method;
            this.params = new HashMap<String, String>();
        }

        public Request(String endpoint) {
            this(endpoint, METHOD_POST);
        }

        public void putParam(String key, String value) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.put(key, value);
        }
    }

    public static interface TaskCallBack {
        public void onProgressUpdate(Response ... var1);

        public void onPostExecute(ArrayList<Response> var1);

        public void onIOException();
    }
}

