/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.network;

import android.content.Context;
import android.database.sqlite.SQLiteOpenHelper;
import android.widget.ProgressBar;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import th.or.nectec.android.library.network.HttpAsyncTask;
import th.or.nectec.android.library.util.DateTime;
import th.or.nectec.android.library.util.JSONInsertOrUpdateTask;

public class DataGrabber {
    public static final int FETCH_NOTHING = -1;
    Context mContext;
    ProgressBar mProgressBar;
    SQLiteOpenHelper mOpenHelper;
    OnFetchFinishListener mFinishListener;
    ArrayList<GrabberPack> mRequestList;
    HttpAsyncTask mPostTask;
    int currentRequest = 0;
    String lastRequestTime;
    private HttpAsyncTask.TaskCallBack mRequestCallback = new HttpAsyncTask.TaskCallBack(){

        @Override
        public void onProgressUpdate(HttpAsyncTask.Response ... values) {
            HttpAsyncTask.Response res = values[0];
            if (res.status != 200) {
                DataGrabber.this.onErrorOccur(1);
                return;
            }
            try {
                JSONObject response = new JSONObject(res.data);
                if (!response.getString("status").equals("success")) {
                    DataGrabber.this.onErrorOccur(3);
                    return;
                }
                final JSONObject returnData = response.optJSONObject("result");
                if (returnData != null) {
                    JSONInsertOrUpdateTask updateTask = new JSONInsertOrUpdateTask(DataGrabber.this.mContext, DataGrabber.this.mOpenHelper, returnData, null, new JSONInsertOrUpdateTask.OnFinishListener(){

                        @Override
                        public void onTaskFinish(String result) {
                            String tablename = DataGrabber.this.mRequestList.get((int)DataGrabber.this.currentRequest).json.tablename;
                            boolean conti = false;
                            int page = 0;
                            JSONObject tab = returnData.optJSONObject(tablename);
                            boolean c = tab.optBoolean("continue");
                            if (c) {
                                conti = true;
                                page = tab.optInt("page");
                            }
                            if (conti) {
                                if (DataGrabber.this.mFinishListener != null) {
                                    DataGrabber.this.mFinishListener.onFetchNextPage(tablename, page, page + 1);
                                }
                                DataGrabber.this.fectchNextPage(DataGrabber.this.currentRequest, returnData, page, page + 1);
                            } else {
                                DataGrabber.this.fetchNextReqeust(tablename, returnData);
                            }
                        }
                    });
                    updateTask.update();
                    updateTask.execute(new JSONInsertOrUpdateTask.Params[]{DataGrabber.this.mRequestList.get((int)DataGrabber.this.currentRequest).json});
                }
            }
            catch (JSONException e) {
                DataGrabber.this.onErrorOccur(2);
            }
        }

        @Override
        public void onPostExecute(ArrayList<HttpAsyncTask.Response> result) {
        }

        @Override
        public void onIOException() {
            DataGrabber.this.onErrorOccur(1);
        }
    };

    public DataGrabber(Context context) {
        this.mContext = context;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setOnFetchFinishListener(OnFetchFinishListener mFinishListener) {
        this.mFinishListener = mFinishListener;
    }

    public void setmProgressBar(ProgressBar mProgressBar) {
        this.mProgressBar = mProgressBar;
    }

    public void setmOpenHelper(SQLiteOpenHelper mOpenHelper) {
        this.mOpenHelper = mOpenHelper;
    }

    public void putRequest(HttpAsyncTask.Request request, JSONInsertOrUpdateTask.Params jsonParam) {
        if (request == null || jsonParam == null) {
            throw new IllegalArgumentException("request or jsonParam is null");
        }
        if (this.mRequestList == null) {
            this.mRequestList = new ArrayList();
        }
        GrabberPack pck = new GrabberPack(request, jsonParam);
        this.mRequestList.add(pck);
        if (this.mProgressBar != null) {
            this.mProgressBar.setMax(this.mRequestList.size());
        }
    }

    public void fetch() {
        if (this.mRequestList == null || this.mRequestList.isEmpty()) {
            throw new InvalidParameterException("reqest list is empty");
        }
        GrabberPack pack = this.mRequestList.get(this.currentRequest);
        if (pack == null) {
            throw new InvalidParameterException("not found request at " + this.currentRequest);
        }
        if (this.mProgressBar != null) {
            this.mProgressBar.setProgress(this.currentRequest + 1);
        }
        this.lastRequestTime = DateTime.getCurrentDateTime();
        this.mPostTask = new HttpAsyncTask(this.mRequestCallback);
        this.mPostTask.execute(new HttpAsyncTask.Request[]{pack.request});
    }

    protected void fectchNextPage(int id2, JSONObject returnData, int currentPage, int nextPage) {
        HttpAsyncTask.Request req = this.mRequestList.get((int)this.currentRequest).request;
        if (req == null) {
            throw new NullPointerException("Request object is NULL");
        }
        req.putParam("page", "" + nextPage);
        this.fetch();
    }

    protected void fetchNextReqeust(String tablename, JSONObject returnData) {
        if (this.mFinishListener != null) {
            this.mFinishListener.onFetchNextRequest(tablename, returnData);
        }
        if (++this.currentRequest < this.mRequestList.size()) {
            this.fetch();
        } else if (this.mFinishListener != null) {
            this.mFinishListener.onFetchFinish();
        }
    }

    private void onErrorOccur(int errorCase) {
        boolean retry = true;
        if (this.mFinishListener != null) {
            retry = this.mFinishListener.onFetchExceptionOccur(errorCase, this.mRequestList.get((int)this.currentRequest).request);
        }
        if (retry) {
            this.fetch();
        } else {
            this.fetchNextReqeust(null, null);
        }
    }

    private static class GrabberPack {
        public HttpAsyncTask.Request request;
        public JSONInsertOrUpdateTask.Params json;

        public GrabberPack(HttpAsyncTask.Request request, JSONInsertOrUpdateTask.Params jsonParam) {
            this.request = request;
            this.json = jsonParam;
        }
    }

    public static interface OnFetchFinishListener {
        public static final int EXCEPTION_IO = 1;
        public static final int EXCEPTION_JSON_FORMAT = 2;
        public static final int EXCEPTION_STATUS_FAIL = 3;

        public void onFetchFinish();

        public void onFetchNextPage(String var1, int var2, int var3);

        public void onFetchNextRequest(String var1, JSONObject var2);

        public boolean onFetchExceptionOccur(int var1, HttpAsyncTask.Request var2);
    }
}

