/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.validator;

import android.content.Context;
import android.text.TextUtils;
import java.util.regex.Pattern;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.form.validator.AbstractValidator;
import th.or.nectec.android.library.form.validator.ValidatorException;

public class RegexValidator
extends AbstractValidator {
    private Pattern mPattern;
    public static final String THAI_ALPHABET = "^[\u0e01-\u0e59 -]{1,} *[\u0e01-\u0e59 -]";
    public static final String THAI_TELEPHONE_NO = "0\\d{8}";
    public static final String THAI_CELL_NO = "0(((6|8|9)\\d{8}))";
    public static final String THAI_POSTCODE = "\\d{5}";
    private int mErrorMessage = R.string.validator_regexp;

    public RegexValidator(Context c) {
        super(c);
    }

    public RegexValidator(Context c, int errorMessage) {
        super(c);
        this.mErrorMessage = errorMessage;
    }

    public RegexValidator(Context c, int errorMessage, String pattern) {
        super(c);
        this.mErrorMessage = errorMessage;
        this.mPattern = Pattern.compile(pattern);
    }

    public void setPattern(String pattern) {
        this.mPattern = Pattern.compile(pattern);
    }

    public void setPattern(Pattern pattern) {
        this.mPattern = pattern;
    }

    @Override
    public boolean isValid(String value) throws ValidatorException {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        if (this.mPattern != null) {
            return this.mPattern.matcher(value).matches();
        }
        throw new ValidatorException("You can set Regexp Pattern first");
    }

    @Override
    public String getMessage() {
        return this.mContext.getString(this.mErrorMessage);
    }
}

