/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import th.or.nectec.android.library.form.IMultiColumnField;
import th.or.nectec.android.library.form.NTForm;
import th.or.nectec.android.library.form.validator.AbstractValidator;
import th.or.nectec.android.library.form.validator.NotEmptyValidator;
import th.or.nectec.android.library.form.validator.ValidatorException;

public abstract class NTField {
    protected NTForm mForm;
    protected String mLabel;
    protected View mView;
    protected String mColumn;
    protected String mInvalidMessage;
    protected HashMap<String, String> mFieldOption;
    protected ArrayList<AbstractValidator> mValidators = new ArrayList();

    public NTField(View view, String Column) {
        this.mView = view;
        view.setTag((Object)("field:" + Column));
        this.mColumn = Column;
    }

    public NTField(String Column, String label) {
        this.mColumn = Column;
        this.mLabel = label;
    }

    protected void onAddToForm(NTForm form) {
        this.mForm = form;
    }

    public String getColumn() {
        return this.mColumn;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public NTField setLabel(String label) {
        this.mLabel = label;
        return this;
    }

    public boolean isMultiColumn() {
        return this instanceof IMultiColumnField;
    }

    public View getView() {
        return this.mView;
    }

    public NTField addValidator(AbstractValidator validator) {
        this.mValidators.add(validator);
        return this;
    }

    public void addValidator(AbstractValidator ... validators) {
        int count = validators.length;
        for (int i = 0; i < count; ++i) {
            this.mValidators.add(validators[i]);
        }
    }

    public NTField refreshValidator(AbstractValidator validator) {
        this.removeValidator();
        this.addValidator(validator);
        return this;
    }

    public void refreshValidator(AbstractValidator ... validators) {
        this.removeValidator();
        this.addValidator(validators);
    }

    public NTField removeValidator() {
        this.mValidators.clear();
        return this;
    }

    public NTField setMandatory(Context context) {
        this.addValidator((AbstractValidator)new NotEmptyValidator(context));
        return this;
    }

    public boolean isValid() {
        String value = this.getValue();
        for (AbstractValidator validator : this.mValidators) {
            try {
                if (validator.isValid(value)) continue;
                this.mInvalidMessage = validator.getMessage();
                this.onInvalid(validator);
                return false;
            }
            catch (ValidatorException e) {
                System.err.println(e.getMessage());
                System.err.println(e.getStackTrace());
                this.mInvalidMessage = e.getMessage();
                return false;
            }
        }
        this.onValid();
        return true;
    }

    protected void onValid() {
        Log.d((String)"NTField", (String)(this.mColumn + " is valid"));
    }

    protected void onInvalid(AbstractValidator validator) {
        Log.d((String)"NTField", (String)(this.mColumn + " Invalid msg=" + validator.getMessage()));
    }

    public abstract String getValue();

    public abstract void setValue(String var1);

    public HashMap<String, String> getFieldOption() {
        return this.mFieldOption;
    }

    public void setFieldOption(HashMap<String, String> option) {
        this.mFieldOption = option;
    }

    public String getMessages() {
        return this.mInvalidMessage;
    }

    public String toString() {
        return "NTField [Class=" + this.getClass() + ", Column=" + this.mColumn + ", getValue()=" + this.getValue() + ", getMessages()=" + this.getMessages() + "]";
    }

    public void setEnabled(boolean enabled) {
        if (this.mView != null) {
            this.mView.setEnabled(enabled);
        }
    }

    protected void buildForm(Context context, ViewGroup parent, boolean isLast, boolean isNextQuestionNoTitle) {
        if (parent.findViewWithTag((Object)("field:" + this.mColumn)) != null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLabel)) {
            TextView label = new TextView(context);
            label.setText((CharSequence)this.mLabel);
            label.setTag((Object)("field-label:" + this.mColumn));
            parent.addView((View)label);
        }
        if (this.mView == null) {
            this.mView = this.onCreateView(context);
        }
        if (this.mView == null) {
            throw new IllegalArgumentException("Invalid onBuildForm() return value or not yet implemented " + this.toString());
        }
        this.mView.setTag((Object)("field:" + this.mColumn));
        parent.addView(this.mView);
        if (!isLast && !isNextQuestionNoTitle) {
            int padding = (int)TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
            View spacing = new View(context);
            LinearLayout.LayoutParams LineParams = new LinearLayout.LayoutParams(-1, padding);
            parent.addView(spacing, (ViewGroup.LayoutParams)LineParams);
        }
    }

    public abstract View onCreateView(Context var1);
}

