/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.database.sqlite;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SQLiteCreateBuilder {
    String mTablename;
    ArrayList<String> mColumnList = new ArrayList();
    StringBuilder mColumnsBuilder;
    StringBuilder mTableConstraintBuilder;
    public static final String CONSTRAINT_PRIMARY_KEY = "PRIMARY KEY";
    public static final String CONSTRAINT_UNIQUE = "UNIQUE";
    public static final String CONSTRAINT_NOT_NULL = "NOT NULL";
    public static final String CONSTRAINT_DEFAULT = "DEFAULT";
    public static final String CONSTRAINT_FOREIGN_KEY = "FOREIGN KEY";
    private static final String TYPE_TEXT = "TEXT";
    private static final String TYPE_INT = "INT";
    private static final String TYPE_REAL = "REAL";
    private static final String TYPE_NUM = "NUM";

    public SQLiteCreateBuilder(String tablename) {
        this.mTablename = tablename;
    }

    private void addColumn(String column, String type, String[] constraint) {
        if (this.mColumnsBuilder == null) {
            this.mColumnsBuilder = new StringBuilder();
        } else {
            this.mColumnsBuilder.append(",");
        }
        this.mColumnsBuilder.append(" " + column + " " + type);
        this.mColumnList.add(column);
        if (constraint != null) {
            int constraintCount = constraint.length;
            for (int i = 0; i < constraintCount; ++i) {
                this.mColumnsBuilder.append(" " + constraint[i]);
            }
        }
    }

    public SQLiteCreateBuilder addTextColumn(String column, String[] constraint) {
        this.addColumn(column, TYPE_TEXT, constraint);
        return this;
    }

    public SQLiteCreateBuilder addTextColumns(String ... columns) {
        int columnCount = columns.length;
        for (int i = 0; i < columnCount; ++i) {
            this.addColumn(columns[i], TYPE_TEXT, null);
        }
        return this;
    }

    public SQLiteCreateBuilder addNumColumn(String column, String[] constraint) {
        this.addColumn(column, TYPE_NUM, constraint);
        return this;
    }

    public SQLiteCreateBuilder addIntColumn(String column, String[] constraint) {
        this.addColumn(column, TYPE_INT, constraint);
        return this;
    }

    public SQLiteCreateBuilder addRealColumn(String column, String[] constraint) {
        this.addColumn(column, TYPE_REAL, constraint);
        return this;
    }

    private void addTableConstraint(String name, String type, String[] columns, String clause) {
        if (this.mTableConstraintBuilder == null) {
            this.mTableConstraintBuilder = new StringBuilder();
        } else {
            this.mTableConstraintBuilder.append(",");
        }
        if (!TextUtils.isEmpty((CharSequence)name)) {
            this.mTableConstraintBuilder.append(" CONSTRANINT " + name);
        }
        this.mTableConstraintBuilder.append(" " + type);
        int columnCount = columns.length;
        if (columnCount > 0) {
            int lastColumn = columnCount - 1;
            this.mTableConstraintBuilder.append(" (");
            for (int i = 0; i < columnCount; ++i) {
                String col = i != lastColumn ? columns[i] + "," : columns[i];
                this.mTableConstraintBuilder.append(" " + col);
            }
            this.mTableConstraintBuilder.append(" )");
        }
        if (!TextUtils.isEmpty((CharSequence)clause)) {
            this.mTableConstraintBuilder.append(" " + name);
        }
    }

    public SQLiteCreateBuilder addPrimaryKey(String ... columns) {
        if (columns.length > 0) {
            // empty if block
        }
        this.addTableConstraint(null, CONSTRAINT_PRIMARY_KEY, columns, null);
        return this;
    }

    public SQLiteCreateBuilder addUNIQUE(String ... columns) {
        if (columns.length > 0) {
            // empty if block
        }
        this.addTableConstraint(null, CONSTRAINT_UNIQUE, columns, null);
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + this.mTablename);
        sb.append("(");
        sb.append((CharSequence)this.mColumnsBuilder);
        if (this.mTableConstraintBuilder != null) {
            sb.append(",");
            sb.append((CharSequence)this.mTableConstraintBuilder);
        }
        sb.append(")");
        return sb.toString();
    }

    public HashMap<String, String> buildProjectionMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        int columnCount = this.mColumnList.size();
        for (int i = 0; i < columnCount; ++i) {
            String column = this.mColumnList.get(i);
            map.put(column, this.mTablename + "." + column);
        }
        return map;
    }

    public SQLiteCreateBuilder fromProjectionMap(HashMap<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value;
            String key = entry.getKey();
            if (!key.equals(value = entry.getValue())) continue;
            this.addColumn(key, TYPE_TEXT, null);
        }
        return this;
    }

    public String toString() {
        return "SQLiteCreateBuilder [tablename=" + this.mTablename + ", columnsBuilder=" + this.mColumnsBuilder.toString() + ", build()=" + this.build() + "]";
    }
}

