/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.utils;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.testdroid.jenkins.auth.BitbarCredentials;
import com.testdroid.jenkins.auth.IBitbarCredentials;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public final class BitbarCredentialsUtils {
    private BitbarCredentialsUtils() {
        throw new IllegalStateException("Utility class");
    }

    @Nonnull
    public static BitbarCredentials getBitbarCredentials(String credentialsId) {
        if (Objects.isNull(credentialsId)) {
            return BitbarCredentials.EMPTY;
        }
        return Optional.ofNullable(BitbarCredentialsUtils.getBitbarCredentialsWrapper(credentialsId)).map(IBitbarCredentials::getCredentials).orElse(BitbarCredentials.EMPTY);
    }

    @Nullable
    public static IBitbarCredentials createBitbarCredentialsWrapperSnapshot(String credentialsId) {
        IBitbarCredentials credentials = BitbarCredentialsUtils.getBitbarCredentialsWrapper(credentialsId);
        return Objects.nonNull(credentials) ? (IBitbarCredentials)CredentialsProvider.snapshot(IBitbarCredentials.class, (Credentials)credentials) : null;
    }

    @Nullable
    public static IBitbarCredentials getBitbarCredentialsWrapper(String credentialsId) {
        if (Objects.isNull(credentialsId)) {
            return null;
        }
        List credentialsList = CredentialsProvider.lookupCredentials(IBitbarCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        return (IBitbarCredentials)CredentialsMatchers.firstOrNull((Iterable)credentialsList, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }
}

