/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.remotesupport;

import com.testdroid.api.model.APIUser;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.auth.TestdroidApiUtil;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import org.jenkinsci.remoting.RoleChecker;

public class MachineIndependentFileUploader
extends MachineIndependentTask
implements FilePath.FileCallable<Long> {
    private TaskListener listener;

    public MachineIndependentFileUploader(TestdroidCloudSettings.DescriptorImpl settings, TaskListener listener) {
        super(settings);
        this.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public Long invoke(File file, VirtualChannel vc) {
        Long result = null;
        try {
            APIUser user = TestdroidApiUtil.createNewApiClient(this).getUser();
            if (file.exists()) {
                result = user.uploadFile(file).getId();
            } else {
                this.listener.getLogger().println(Messages.ERROR_FILE_NOT_FOUND(file.getAbsolutePath()));
            }
        }
        catch (Exception ex) {
            this.listener.getLogger().println(Messages.UPLOADING_FILE_ERROR(file.getAbsolutePath(), ex));
            ex.printStackTrace(this.listener.getLogger());
        }
        return result;
    }
}

