/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.scheduler;

import com.testdroid.jenkins.Messages;
import hudson.Plugin;
import hudson.model.Api;
import hudson.model.ModelObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class HookUrlResultWaiter
extends Plugin
implements ModelObject {
    private static final Logger LOGGER = Logger.getLogger(HookUrlResultWaiter.class.getName());
    private static final Map<Long, Object> runIdWaitingObjectsMap = new HashMap<Long, Object>();

    static void removeFromWaitList(Long testRunId) {
        runIdWaitingObjectsMap.remove(testRunId);
    }

    static void addToWaitList(Long testRunId, Object waitingObject) {
        runIdWaitingObjectsMap.put(testRunId, waitingObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingObject(Long testRunId) {
        Object waitingObject = runIdWaitingObjectsMap.get(testRunId);
        if (waitingObject != null) {
            Object object = waitingObject;
            synchronized (object) {
                waitingObject.notify();
            }
        }
    }

    public String getDisplayName() {
        return Messages.PLUGIN_NAME();
    }

    public Api getApi() {
        return new TestdroidRunInCloudApi(this);
    }

    public static class TestdroidRunInCloudApi
    extends Api {
        private TestdroidRunInCloudApi(HookUrlResultWaiter thisPlugin) {
            super((Object)thisPlugin);
        }

        public void doJson(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
            HookUrlResultWaiter plugin = (HookUrlResultWaiter)((Object)this.bean);
            LOGGER.log(Level.INFO, String.format(Messages.RECEIVED_REST_JSON(), plugin.getDisplayName()));
            if (req.getMethod().toLowerCase().equals("post") && req.hasParameter("testRunId")) {
                plugin.notifyWaitingObject(Long.parseLong(req.getParameter("testRunId")));
            } else {
                LOGGER.log(Level.INFO, String.format(Messages.REQUEST_NEEDS_TESTRUNID(), plugin.getDisplayName()));
            }
        }
    }
}

