/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.google.inject.Inject;
import com.testdroid.api.model.APIDevice;
import com.testdroid.jenkins.RunInCloudBuilder;
import com.testdroid.jenkins.RunInCloudDescriptorHelper;
import com.testdroid.jenkins.WaitForResultsBlock;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PipelineCloudStep
extends AbstractStepImpl {
    private String appPath;
    private String deviceGroupId;
    private String dataPath;
    private String testPath;
    private boolean failBuildIfThisStepFailed;
    private String keyValuePairs;
    private String language;
    private String projectId;
    private String scheduler;
    private String screenshotsDirectory;
    private String testCasesSelect;
    private String testCasesValue;
    private String testRunName;
    private String testRunner;
    private String virusScanTimeout;
    private String withAnnotation;
    private String withoutAnnotation;
    private String testTimeout;
    private String credentialsId;
    private String cloudUrl;
    private String cloudUIUrl;
    private Long frameworkId;
    private APIDevice.OsType osType;
    private WaitForResultsBlock waitForResultsBlock;

    @DataBoundConstructor
    public PipelineCloudStep(String projectId, String deviceGroupId) {
        this.projectId = projectId;
        this.deviceGroupId = deviceGroupId;
    }

    @DataBoundSetter
    public void setTestRunName(String testRunName) {
        if (StringUtils.isNotBlank((CharSequence)testRunName)) {
            this.testRunName = testRunName;
        }
    }

    @DataBoundSetter
    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    @DataBoundSetter
    public void setTestRunner(String testRunner) {
        if (StringUtils.isNotBlank((CharSequence)testRunner)) {
            this.testRunner = testRunner;
        }
    }

    @DataBoundSetter
    public void setTestPath(String testPath) {
        if (StringUtils.isNotBlank((CharSequence)testPath)) {
            this.testPath = testPath;
        }
    }

    @DataBoundSetter
    public void setScreenshotsDirectory(String screenshotsDirectory) {
        if (StringUtils.isNotBlank((CharSequence)screenshotsDirectory)) {
            this.screenshotsDirectory = screenshotsDirectory;
        }
    }

    @DataBoundSetter
    public void setKeyValuePairs(String keyValuePairs) {
        if (StringUtils.isNotBlank((CharSequence)keyValuePairs)) {
            this.keyValuePairs = keyValuePairs;
        }
    }

    @DataBoundSetter
    public void setWithAnnotation(String withAnnotation) {
        if (StringUtils.isNotBlank((CharSequence)withAnnotation)) {
            this.withAnnotation = withAnnotation;
        }
    }

    @DataBoundSetter
    public void setWithoutAnnotation(String withoutAnnotation) {
        if (StringUtils.isNotBlank((CharSequence)withoutAnnotation)) {
            this.withoutAnnotation = withoutAnnotation;
        }
    }

    @DataBoundSetter
    public void setTestCasesSelect(String testCasesSelect) {
        if (StringUtils.isNotBlank((CharSequence)testCasesSelect) && !testCasesSelect.equalsIgnoreCase(RunInCloudDescriptorHelper.DEFAULT_TEST_CASES_SELECT)) {
            this.testCasesSelect = testCasesSelect;
        }
    }

    @DataBoundSetter
    public void setTestCasesValue(String testCasesValue) {
        if (StringUtils.isNotBlank((CharSequence)testCasesValue)) {
            this.testCasesValue = testCasesValue;
        }
    }

    @DataBoundSetter
    public void setDataPath(String dataPath) {
        if (StringUtils.isNotBlank((CharSequence)dataPath)) {
            this.dataPath = dataPath;
        }
    }

    @DataBoundSetter
    public void setLanguage(String language) {
        if (StringUtils.isNotBlank((CharSequence)language) && !language.equals(RunInCloudDescriptorHelper.DEFAULT_LANGUAGE)) {
            this.language = language;
        }
    }

    @DataBoundSetter
    public void setScheduler(String scheduler) {
        if (StringUtils.isNotBlank((CharSequence)scheduler) && !scheduler.equalsIgnoreCase(RunInCloudDescriptorHelper.DEFAULT_SCHEDULER)) {
            this.scheduler = scheduler.toUpperCase();
        }
    }

    @DataBoundSetter
    public void setTestTimeout(String testTimeout) {
        if (StringUtils.isNotBlank((CharSequence)testTimeout)) {
            this.testTimeout = testTimeout;
        }
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    @DataBoundSetter
    public void setCloudUIUrl(String cloudUIUrl) {
        this.cloudUIUrl = cloudUIUrl;
    }

    @DataBoundSetter
    public void setFailBuildIfThisStepFailed(boolean failBuildIfThisStepFailed) {
        this.failBuildIfThisStepFailed = failBuildIfThisStepFailed;
    }

    @DataBoundSetter
    public void setFrameworkId(Long frameworkId) {
        this.frameworkId = frameworkId;
    }

    @DataBoundSetter
    public void setOsType(APIDevice.OsType osType) {
        this.osType = osType;
    }

    @DataBoundSetter
    public void setWaitForResultsBlock(WaitForResultsBlock waitForResultsBlock) {
        this.waitForResultsBlock = waitForResultsBlock;
    }

    @DataBoundSetter
    public void setVirusScanTimeout(String virusScanTimeout) {
        this.virusScanTimeout = virusScanTimeout;
    }

    public String getVirusScanTimeout() {
        return this.virusScanTimeout;
    }

    public WaitForResultsBlock getWaitForResultsBlock() {
        return this.waitForResultsBlock;
    }

    public String getTestRunName() {
        return this.testRunName;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getDeviceGroupId() {
        return this.deviceGroupId;
    }

    public String getTestRunner() {
        return this.testRunner;
    }

    public String getScreenshotsDirectory() {
        return this.screenshotsDirectory;
    }

    public String getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public String getWithAnnotation() {
        return this.withAnnotation;
    }

    public String getWithoutAnnotation() {
        return this.withoutAnnotation;
    }

    public String getTestCasesSelect() {
        return StringUtils.isNotBlank((CharSequence)this.testCasesSelect) ? this.testCasesSelect.toUpperCase() : RunInCloudDescriptorHelper.DEFAULT_TEST_CASES_SELECT;
    }

    public String getTestCasesValue() {
        return this.testCasesValue;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getLanguage() {
        return StringUtils.isNotBlank((CharSequence)this.language) ? this.language : RunInCloudDescriptorHelper.DEFAULT_LANGUAGE;
    }

    public String getScheduler() {
        return StringUtils.isNotBlank((CharSequence)this.scheduler) ? this.scheduler.toUpperCase() : RunInCloudDescriptorHelper.DEFAULT_SCHEDULER;
    }

    public boolean isFailBuildIfThisStepFailed() {
        return this.failBuildIfThisStepFailed;
    }

    public String getTestTimeout() {
        return this.testTimeout;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    public String getCloudUIUrl() {
        return this.cloudUIUrl;
    }

    public Long getFrameworkId() {
        return this.frameworkId;
    }

    public APIDevice.OsType getOsType() {
        return this.osType;
    }

    public static final class CloudStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient PipelineCloudStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath workspace;

        protected Boolean run() throws IOException, InterruptedException {
            RunInCloudBuilder builder = new RunInCloudBuilder(this.step.getProjectId(), this.step.getAppPath(), this.step.getTestPath(), this.step.getDataPath(), this.step.getTestRunName(), this.step.getScheduler(), this.step.getTestRunner(), this.step.getDeviceGroupId(), this.step.getLanguage(), this.step.getScreenshotsDirectory(), this.step.getKeyValuePairs(), this.step.getWithAnnotation(), this.step.getWithoutAnnotation(), this.step.getTestCasesSelect(), this.step.getTestCasesValue(), this.step.isFailBuildIfThisStepFailed(), this.step.getVirusScanTimeout(), this.step.getWaitForResultsBlock(), this.step.getTestTimeout(), this.step.getCredentialsId(), this.step.getCloudUrl(), this.step.getCloudUIUrl(), this.step.getFrameworkId(), this.step.getOsType());
            return builder.completeRun(this.run, this.workspace, this.launcher, this.listener);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl
    implements RunInCloudDescriptorHelper {
        public DescriptorImpl() {
            super(CloudStepExecution.class);
        }

        public String getFunctionName() {
            return "runInCloud";
        }

        public String getDisplayName() {
            return "Start a run in Bitbar Cloud";
        }
    }
}

