/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.assertj.assertions;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Unit;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractUnitAssert<S extends AbstractUnitAssert<S, A>, A extends Unit>
extends AbstractObjectAssert<S, A> {
    protected AbstractUnitAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasBaseUnits(Map baseUnits) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting baseUnits of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualBaseUnits = ((Unit)this.actual).getBaseUnits();
        if (!Objects.areEqual((Object)actualBaseUnits, (Object)baseUnits)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, baseUnits, actualBaseUnits});
        }
        return (S)((Object)((AbstractUnitAssert)this.myself));
    }

    public S hasDimension(Dimension dimension) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting dimension of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Dimension actualDimension = ((Unit)this.actual).getDimension();
        if (!Objects.areEqual((Object)actualDimension, (Object)dimension)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, dimension, actualDimension});
        }
        return (S)((Object)((AbstractUnitAssert)this.myself));
    }

    public S hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((Unit)this.actual).getName();
        if (!Objects.areEqual((Object)actualName, (Object)name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return (S)((Object)((AbstractUnitAssert)this.myself));
    }

    public S hasSymbol(String symbol) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting symbol of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSymbol = ((Unit)this.actual).getSymbol();
        if (!Objects.areEqual((Object)actualSymbol, (Object)symbol)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, symbol, actualSymbol});
        }
        return (S)((Object)((AbstractUnitAssert)this.myself));
    }

    public S hasSystemUnit(Unit systemUnit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting systemUnit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Unit actualSystemUnit = ((Unit)this.actual).getSystemUnit();
        if (!Objects.areEqual((Object)actualSystemUnit, (Object)systemUnit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, systemUnit, actualSystemUnit});
        }
        return (S)((Object)((AbstractUnitAssert)this.myself));
    }
}

