/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.plot;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.PieChart;
import javax.swing.SwingUtilities;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.plotting.fx.FxPie;
import tech.tablesaw.plotting.fx.FxPlot;
import tech.tablesaw.reducing.NumericSummaryTable;

public class Pie
extends FxPlot {
    private static final String WINDOW_TITLE = "Tablesaw";

    public static void show(String title, CategoryColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                Pie.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, ShortColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                Pie.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, IntColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                Pie.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, NumericSummaryTable table) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                if (table.column(0) instanceof CategoryColumn) {
                    Pie.initAndShowGUI(title, table.categoryColumn(0), table.nCol(1), 640, 480);
                }
                if (table.column(0) instanceof ShortColumn) {
                    Pie.initAndShowGUI(title, table.shortColumn(0), table.nCol(1), 640, 480);
                }
                if (table.column(0) instanceof IntColumn) {
                    Pie.initAndShowGUI(title, table.intColumn(0), table.nCol(1), 640, 480);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static void initAndShowGUI(String title, CategoryColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = Pie.getJfxPanel(WINDOW_TITLE, width, height);
        PieChart chart = FxPie.chart(title, categoryColumn, numericColumn);
        Platform.runLater(() -> Pie.initFX(fxPanel, chart));
    }

    private static void initAndShowGUI(String title, ShortColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = Pie.getJfxPanel(WINDOW_TITLE, width, height);
        PieChart chart = FxPie.chart(title, categoryColumn, numericColumn);
        Platform.runLater(() -> Pie.initFX(fxPanel, chart));
    }

    private static void initAndShowGUI(String title, IntColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = Pie.getJfxPanel(WINDOW_TITLE, width, height);
        PieChart chart = FxPie.chart(title, categoryColumn, numericColumn);
        Platform.runLater(() -> Pie.initFX(fxPanel, chart));
    }

    private static void initFX(JFXPanel fxPanel, PieChart chart) {
        Scene scene = new Scene((Parent)chart, chart.getWidth(), chart.getHeight());
        fxPanel.setScene(scene);
    }
}

