/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotting.fx.FxBuilder;

public class FxBar
extends FxBuilder {
    public static BarChart<String, Number> chart(String title, Table table, String categoryColumnName, String numericColumnName) {
        CategoryColumn categoryColumn = table.categoryColumn(categoryColumnName);
        NumericColumn numericColumn = table.nCol(numericColumnName);
        return FxBar.chart(title, categoryColumn, numericColumn);
    }

    public static BarChart<String, Number> chart(String title, CategoryColumn categoryColumn, NumericColumn numericColumn) {
        CategoryAxis categoryAxis = FxBar.getCategoryAxis((Column)categoryColumn);
        NumberAxis numberAxis = FxBar.getNumberAxis(numericColumn);
        BarChart<String, Number> barChart = FxBar.getBarChart(title, categoryAxis, numberAxis);
        ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)categoryColumn.get(i), (Object)Float.valueOf(numericColumn.getFloat(i))));
        }
        barChart.getData().addAll((Object[])new XYChart.Series[]{FxBar.getSeries(numericColumn, data)});
        return barChart;
    }

    public static BarChart<String, Number> chart(String title, ShortColumn categoryColumn, NumericColumn numericColumn) {
        CategoryAxis categoryAxis = FxBar.getCategoryAxis((Column)categoryColumn);
        NumberAxis numberAxis = FxBar.getNumberAxis(numericColumn);
        BarChart<String, Number> barChart = FxBar.getBarChart(title, categoryAxis, numberAxis);
        ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)categoryColumn.getString(i), (Object)Float.valueOf(numericColumn.getFloat(i))));
        }
        barChart.getData().addAll((Object[])new XYChart.Series[]{FxBar.getSeries(numericColumn, data)});
        return barChart;
    }

    public static BarChart<String, Number> chart(String title, IntColumn categoryColumn, NumericColumn numericColumn) {
        CategoryAxis categoryAxis = FxBar.getCategoryAxis((Column)categoryColumn);
        NumberAxis numberAxis = FxBar.getNumberAxis(numericColumn);
        BarChart<String, Number> barChart = FxBar.getBarChart(title, categoryAxis, numberAxis);
        ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)categoryColumn.getString(i), (Object)Float.valueOf(numericColumn.getFloat(i))));
        }
        barChart.getData().addAll((Object[])new XYChart.Series[]{FxBar.getSeries(numericColumn, data)});
        return barChart;
    }
}

