/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.smile;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JFrame;
import smile.plot.Histogram;
import smile.plot.PlotCanvas;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.plotting.smile.SmilePlotUtils;

public class SmileHistogram {
    public static PlotCanvas create(String plotTitle, String xTitle, String yTitle, NumberColumn column) {
        PlotCanvas canvas = Histogram.plot((double[])column.asDoubleArray());
        canvas.setForeground(Color.DARK_GRAY);
        canvas.setTitle(plotTitle);
        canvas.setAxisLabel(0, xTitle);
        canvas.setAxisLabel(1, yTitle);
        return canvas;
    }

    public static PlotCanvas create(double[] x, String yTitle) {
        return Histogram.plot((String)yTitle, (double[])x);
    }

    public static void show(double[] x) {
        JFrame frame = SmilePlotUtils.getjFrame(600, 400);
        String yTitle = "proportion";
        PlotCanvas canvas = SmileHistogram.create(x, yTitle);
        canvas.setAxisLabel(1, yTitle);
        frame.add((Component)canvas);
        frame.setVisible(true);
    }

    public static void show(String plotTitle, NumberColumn column) {
        JFrame frame = SmilePlotUtils.getjFrame(600, 400);
        PlotCanvas canvas = SmileHistogram.create(plotTitle, column.name(), "proportion", column);
        frame.add((Component)canvas);
        frame.setVisible(true);
    }

    public static void show(NumberColumn column) {
        JFrame frame = SmilePlotUtils.getjFrame(600, 400);
        PlotCanvas canvas = SmileHistogram.create("", column.name(), "proportion", column);
        frame.add((Component)canvas);
        frame.setVisible(true);
    }
}

