/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.xchart;

import java.util.Arrays;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Theme;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.plotting.xchart.TablesawTheme;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.table.ViewGroup;
import tech.tablesaw.util.DoubleArrays;

public class XchartLine {
    private static final String WINDOW_TITLE = "Tablesaw";

    public static void show(String chartTitle, NumericColumn yColumn) {
        double[] x = DoubleArrays.toN((int)yColumn.size());
        XchartLine.show(chartTitle, x, yColumn, 600, 400);
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn, int markerSize) {
        XchartLine.show(chartTitle, xColumn, yColumn, 600, 400, markerSize);
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn) {
        int markerSize = 2;
        XchartLine.show(chartTitle, xColumn, yColumn, 600, 400, markerSize);
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn, ViewGroup group) {
        XYChart chart = new XYChart(600, 400);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xColumn.name());
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(5);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        for (TemporaryView view : group) {
            double[] xData = view.numericColumn(xColumn.name()).asDoubleArray();
            double[] yData = view.numericColumn(yColumn.name()).asDoubleArray();
            chart.addSeries(view.name(), Arrays.copyOf(xData, xData.length), Arrays.copyOf(yData, yData.length));
        }
        new SwingWrapper((Chart)chart).displayChart(WINDOW_TITLE);
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn, ViewGroup group, int markerSize) {
        XYChart chart = new XYChart(600, 400);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xColumn.name());
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(markerSize);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        for (TemporaryView view : group) {
            double[] xData = view.numericColumn(xColumn.name()).asDoubleArray();
            double[] yData = view.numericColumn(yColumn.name()).asDoubleArray();
            chart.addSeries(view.name(), Arrays.copyOf(xData, xData.length), Arrays.copyOf(yData, yData.length));
        }
        new SwingWrapper((Chart)chart).displayChart(WINDOW_TITLE);
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn, int width, int height, int markerSize) {
        double[] xData = xColumn.asDoubleArray();
        double[] yData = yColumn.asDoubleArray();
        XYChart chart = new XYChart(width, height);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xColumn.name());
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(markerSize);
        XYSeries series = chart.addSeries(yColumn.name() + " by " + xColumn.name(), xData, yData);
        series.setMarker(SeriesMarkers.CIRCLE);
        new SwingWrapper((Chart)chart).displayChart(WINDOW_TITLE);
    }

    public static void show(String chartTitle, double[] xData, NumericColumn yColumn, int width, int height) {
        double[] yData = yColumn.asDoubleArray();
        XYChart chart = new XYChart(width, height);
        chart.setTitle(chartTitle);
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(2);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        XYSeries series = chart.addSeries("Ranked: " + yColumn.name(), xData, yData);
        series.setMarker(SeriesMarkers.CIRCLE);
        new SwingWrapper((Chart)chart).displayChart(WINDOW_TITLE);
    }

    public static void show(String chartTitle, NumericColumn x, NumericColumn ... ySeries) {
        XYChart chart = new XYChart(600, 400);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(x.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(1);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
        for (NumericColumn y : ySeries) {
            chart.addSeries(y.name(), x.asDoubleArray(), y.asDoubleArray());
        }
        new SwingWrapper((Chart)chart).displayChart(WINDOW_TITLE);
    }
}

