/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.plot;

import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.plotting.xchart.XchartLine;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.Selection;

public class Control {
    public static void show(String name, NumericColumn data) {
        Control.show(name, data, 0, data.size());
    }

    public static void show(String name, NumericColumn sourceData, int controlRangeStart, int controlRangeEnd) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(controlRangeStart, controlRangeEnd);
        NumericColumn data = (NumericColumn)sourceData.subset((Selection)selection);
        double avg = data.mean();
        double stdDev = data.standardDeviation();
        double controlLimit = 3.0 * stdDev;
        Control.show(name, data, avg, controlLimit);
    }

    public static void show(String name, NumericColumn data, double avg, double controlLimit) {
        IntColumn index = new IntColumn("Observations");
        DoubleColumn mean = new DoubleColumn("Mean");
        DoubleColumn ucl = new DoubleColumn("UCL");
        DoubleColumn lcl = new DoubleColumn("LCL");
        for (int i = 0; i < data.size(); ++i) {
            index.append(i + 1);
            mean.append(avg);
            ucl.append(avg + controlLimit);
            lcl.append(avg - controlLimit);
        }
        XchartLine.show(name, (NumericColumn)index, new NumericColumn[]{data, mean, ucl, lcl});
    }
}

