/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;

public class Margin
extends Component {
    private final int left;
    private final int right;
    private final int top;
    private final int bottom;
    private final int pad;
    private final boolean autoExpand;

    public static MarginBuilder builder() {
        return new MarginBuilder();
    }

    private Margin(MarginBuilder builder) {
        this.left = builder.left;
        this.right = builder.right;
        this.top = builder.top;
        this.bottom = builder.bottom;
        this.pad = builder.pad;
        this.autoExpand = builder.autoExpand;
    }

    @Override
    public String asJavascript() {
        return this.asJavascript("margin_template.html");
    }

    @Override
    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("top", this.top);
        context.put("bottom", this.bottom);
        context.put("right", this.right);
        context.put("left", this.left);
        context.put("pad", this.pad);
        context.put("autoExpand", this.autoExpand);
        return context;
    }

    public static class MarginBuilder {
        private int left = 80;
        private int right = 80;
        private int top = 100;
        private int bottom = 80;
        private int pad = 0;
        private boolean autoExpand = true;

        private MarginBuilder() {
        }

        public MarginBuilder top(int top) {
            this.top = top;
            return this;
        }

        public MarginBuilder bottom(int bottom) {
            this.bottom = bottom;
            return this;
        }

        public MarginBuilder left(int left) {
            this.left = left;
            return this;
        }

        public MarginBuilder right(int right) {
            this.right = right;
            return this;
        }

        public MarginBuilder padding(int padding) {
            this.pad = padding;
            return this;
        }

        public MarginBuilder autoExpand(boolean autoExpand) {
            this.autoExpand = autoExpand;
            return this;
        }

        public Margin build() {
            return new Margin(this);
        }
    }
}

