/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.plotly.components.TemplateUtils;

public abstract class Component {
    protected final PebbleEngine engine = TemplateUtils.getNewEngine();

    public abstract String asJavascript();

    protected abstract Map<String, Object> getContext();

    protected String asJavascript(String filename) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate(filename);
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    public String toString() {
        return this.asJavascript();
    }
}

