/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.DelegatingLoader;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class TemplateUtils {
    private static Collection<String> templateLocations = new ArrayList<String>();

    public static void setTemplateLocations(String ... locations) {
        templateLocations = Arrays.asList(locations);
    }

    public static PebbleEngine getNewEngine() {
        PebbleEngine engine;
        try {
            ClasspathLoader loader = new ClasspathLoader();
            if (templateLocations != null && templateLocations.size() > 0) {
                ArrayList<Object> loaders = new ArrayList<Object>();
                for (String templateLocation : templateLocations) {
                    FileLoader fileLoader = new FileLoader();
                    fileLoader.setPrefix(templateLocation);
                    loaders.add(fileLoader);
                }
                loaders.add(loader);
                loader = new DelegatingLoader(loaders);
            }
            engine = new PebbleEngine.Builder().loader((Loader)loader).strictVariables(false).build();
        }
        catch (PebbleException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        return engine;
    }
}

