/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.google.common.base.Preconditions;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.components.HoverLabel;
import tech.tablesaw.plotly.traces.AbstractTrace;

public abstract class TraceBuilder {
    protected AbstractTrace.Visibility visible = AbstractTrace.DEFAULT_VISIBILITY;
    protected boolean showLegend = false;
    protected String legendGroup = " ";
    protected double opacity = 1.0;
    protected String name;
    protected String[] ids;
    protected HoverLabel hoverLabel;
    protected String xAxis = "x";
    protected String yAxis = "y";

    TraceBuilder() {
    }

    protected abstract String getType();

    public TraceBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TraceBuilder opacity(double n) {
        Preconditions.checkArgument((n >= 0.0 && n <= 1.0 ? 1 : 0) != 0);
        this.opacity = n;
        return this;
    }

    public TraceBuilder legendGroup(String group) {
        this.legendGroup = group;
        return this;
    }

    protected TraceBuilder showLegend(boolean showLegend) {
        this.showLegend = showLegend;
        return this;
    }

    protected TraceBuilder visible(AbstractTrace.Visibility visibility) {
        this.visible = visibility;
        return this;
    }

    protected TraceBuilder hoverLabel(HoverLabel hoverLabel) {
        this.hoverLabel = hoverLabel;
        return this;
    }

    protected static String[] columnToStringArray(Column<?> column) {
        String[] x = new String[column.size()];
        for (int i = 0; i < column.size(); ++i) {
            x[i] = column.getString(i);
        }
        return x;
    }

    public TraceBuilder xAxis(String xAxis) {
        Preconditions.checkArgument((boolean)xAxis.matches("^x[0-9]*$"));
        this.xAxis = xAxis;
        return this;
    }

    public TraceBuilder yAxis(String yAxis) {
        Preconditions.checkArgument((boolean)yAxis.matches("^y[0-9]*$"));
        this.yAxis = yAxis;
        return this;
    }
}

