/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.Marker;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class HistogramTrace
extends AbstractTrace {
    private final double[] x;
    private final double opacity;
    private final int nBinsX;
    private final int nBinsY;
    private final boolean autoBinX;
    private final boolean autoBinY;
    private final Marker marker;

    public static HistogramBuilder builder(double[] values) {
        return new HistogramBuilder(values);
    }

    public static HistogramBuilder builder(NumericColumn<? extends Number> values) {
        return new HistogramBuilder(values.asDoubleArray());
    }

    private HistogramTrace(HistogramBuilder builder) {
        super(builder);
        this.x = builder.x;
        this.nBinsX = builder.nBinsX;
        this.nBinsY = builder.nBinsY;
        this.autoBinX = builder.autoBinX;
        this.autoBinY = builder.autoBinY;
        this.opacity = builder.opacity;
        this.marker = builder.marker;
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext(i));
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        context.put("x", Utils.dataAsString(this.x));
        context.put("opacity", this.opacity);
        context.put("nBinsX", this.nBinsX);
        context.put("nBinsY", this.nBinsY);
        context.put("autoBinX", this.autoBinX);
        context.put("autoBinY", this.autoBinY);
        if (this.marker != null) {
            context.put("marker", this.marker);
        }
        return context;
    }

    public static class HistogramBuilder
    extends TraceBuilder {
        private final String type = "histogram";
        private int nBinsX;
        private int nBinsY;
        private boolean autoBinX;
        private boolean autoBinY;
        private final double[] x;
        private Marker marker;

        private HistogramBuilder(double[] values) {
            this.x = values;
        }

        public HistogramBuilder nBinsX(int bins) {
            this.nBinsX = bins;
            return this;
        }

        public HistogramBuilder nBinsY(int bins) {
            this.nBinsY = bins;
            return this;
        }

        public HistogramBuilder autoBinX(boolean autoBinX) {
            this.autoBinX = autoBinX;
            return this;
        }

        public HistogramBuilder autoBinY(boolean autoBinY) {
            this.autoBinY = autoBinY;
            return this;
        }

        public HistogramBuilder marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public HistogramBuilder opacity(double opacity) {
            super.opacity(opacity);
            return this;
        }

        @Override
        public HistogramBuilder showLegend(boolean b) {
            super.showLegend(b);
            return this;
        }

        @Override
        public HistogramBuilder name(String name) {
            super.name(name);
            return this;
        }

        public HistogramTrace build() {
            return new HistogramTrace(this);
        }

        @Override
        protected String getType() {
            return "histogram";
        }
    }
}

