/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;

public class Margin
extends Component {
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int pad;
    private boolean autoExpand;

    public static MarginBuilder builder() {
        return new MarginBuilder();
    }

    private Margin(MarginBuilder builder) {
        this.left = builder.left;
        this.right = builder.right;
        this.top = builder.top;
        this.bottom = builder.bottom;
        this.pad = builder.pad;
        this.autoExpand = builder.autoExpand;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("margin_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("top", this.top);
        context.put("bottom", this.bottom);
        context.put("right", this.right);
        context.put("left", this.left);
        context.put("pad", this.pad);
        context.put("autoExpand", this.autoExpand);
        return context;
    }

    public static class MarginBuilder {
        int left = 80;
        int right = 80;
        int top = 100;
        int bottom = 80;
        int pad = 0;
        boolean autoExpand = true;

        private MarginBuilder() {
        }

        public MarginBuilder top(int top) {
            this.top = top;
            return this;
        }

        public MarginBuilder bottom(int bottom) {
            this.bottom = bottom;
            return this;
        }

        public MarginBuilder left(int left) {
            this.left = left;
            return this;
        }

        public MarginBuilder right(int right) {
            this.right = right;
            return this;
        }

        public MarginBuilder padding(int padding) {
            this.pad = padding;
            return this;
        }

        public MarginBuilder autoExpand(boolean autoExpand) {
            this.autoExpand = autoExpand;
            return this;
        }

        public Margin build() {
            return new Margin(this);
        }
    }
}

