/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.google.common.base.Preconditions;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;
import tech.tablesaw.plotly.components.TickSettings;

public class ColorBar
extends Component {
    private static ThicknessMode DEFAULT_THICKNESS_MODE = ThicknessMode.PIXELS;
    private static double DEFAULT_THICKNESS = 30.0;
    private static LenMode DEFAULT_LEN_MODE = LenMode.FRACTION;
    private static double DEFAULT_LEN = 1.0;
    private static double DEFAULT_X = 1.02;
    private static double DEFAULT_Y = 0.5;
    private static int DEFAULT_X_PAD = 10;
    private static int DEFAULT_Y_PAD = 10;
    private static Xanchor DEFAULT_X_ANCHOR = Xanchor.LEFT;
    private static Yanchor DEFAULT_Y_ANCHOR = Yanchor.MIDDLE;
    private static String DEFAULT_OUTLINE_COLOR = "444";
    private static String DEFAULT_BORDER_COLOR = "444";
    private static int DEFAULT_BORDER_WIDTH = 1;
    private static int DEFAULT_OUTLINE_WIDTH = 0;
    private static String DEFAULT_BG_COLOR = "rgba(0,0,0,0)";
    private final ThicknessMode thicknessMode;
    private final double thickness;
    private final LenMode lenMode;
    private final double len;
    private final double x;
    private final int xPad;
    private final int yPad;
    private final double y;
    private final Xanchor xAnchor;
    private final Yanchor yAnchor;
    private final String outlineColor;
    private final int outlineWidth;
    private final String borderColor;
    private final int borderWidth;
    private final String bgColor;
    private final TickSettings tickSettings;

    private ColorBar(ColorBarBuilder builder) {
        this.thicknessMode = builder.thicknessMode;
        this.lenMode = builder.lenMode;
        this.thickness = builder.thickness;
        this.len = builder.len;
        this.x = builder.x;
        this.y = builder.y;
        this.xPad = builder.xPad;
        this.yPad = builder.yPad;
        this.xAnchor = builder.xAnchor;
        this.yAnchor = builder.yAnchor;
        this.outlineColor = builder.outlineColor;
        this.borderColor = builder.borderColor;
        this.bgColor = builder.bgColor;
        this.borderWidth = builder.borderWidth;
        this.outlineWidth = builder.outlineWidth;
        this.tickSettings = builder.tickSettings;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("axis_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (!this.thicknessMode.equals((Object)DEFAULT_THICKNESS_MODE)) {
            context.put("thicknessMode", (Object)this.thicknessMode);
        }
        if (!this.lenMode.equals((Object)DEFAULT_LEN_MODE)) {
            context.put("lenMode", (Object)this.lenMode);
        }
        if (this.len != DEFAULT_LEN) {
            context.put("len", this.len);
        }
        if (this.thickness != DEFAULT_THICKNESS) {
            context.put("thickness", this.thickness);
        }
        if (this.x != DEFAULT_X) {
            context.put("x", this.x);
        }
        if (this.y != DEFAULT_Y) {
            context.put("y", this.y);
        }
        if (this.xPad != DEFAULT_X_PAD) {
            context.put("xPad", this.xPad);
        }
        if (this.yPad != DEFAULT_Y_PAD) {
            context.put("yPad", this.yPad);
        }
        if (this.borderWidth != DEFAULT_BORDER_WIDTH) {
            context.put("borderWidth", this.borderWidth);
        }
        if (this.outlineWidth != DEFAULT_OUTLINE_WIDTH) {
            context.put("outlineWidth", this.outlineWidth);
        }
        if (!this.xAnchor.equals((Object)DEFAULT_X_ANCHOR)) {
            context.put("xAnchor", (Object)this.xAnchor);
        }
        if (!this.yAnchor.equals((Object)DEFAULT_Y_ANCHOR)) {
            context.put("yAnchor", (Object)this.yAnchor);
        }
        if (!this.outlineColor.equals(DEFAULT_OUTLINE_COLOR)) {
            context.put("outlineColor", this.outlineColor);
        }
        if (!this.borderColor.equals(DEFAULT_BORDER_COLOR)) {
            context.put("borderColor", this.borderColor);
        }
        if (!this.bgColor.equals(DEFAULT_BG_COLOR)) {
            context.put("bgColor", this.bgColor);
        }
        if (this.tickSettings != null) {
            this.tickSettings.updateContext(context);
        }
        return context;
    }

    public static ColorBarBuilder colorBarBuilder() {
        return new ColorBarBuilder();
    }

    static /* synthetic */ ThicknessMode access$000() {
        return DEFAULT_THICKNESS_MODE;
    }

    static /* synthetic */ double access$100() {
        return DEFAULT_THICKNESS;
    }

    static /* synthetic */ LenMode access$200() {
        return DEFAULT_LEN_MODE;
    }

    static /* synthetic */ double access$300() {
        return DEFAULT_LEN;
    }

    static /* synthetic */ double access$400() {
        return DEFAULT_X;
    }

    static /* synthetic */ int access$500() {
        return DEFAULT_X_PAD;
    }

    static /* synthetic */ int access$600() {
        return DEFAULT_Y_PAD;
    }

    static /* synthetic */ double access$700() {
        return DEFAULT_Y;
    }

    static /* synthetic */ Xanchor access$800() {
        return DEFAULT_X_ANCHOR;
    }

    static /* synthetic */ Yanchor access$900() {
        return DEFAULT_Y_ANCHOR;
    }

    static /* synthetic */ String access$1000() {
        return DEFAULT_OUTLINE_COLOR;
    }

    static /* synthetic */ int access$1100() {
        return DEFAULT_OUTLINE_WIDTH;
    }

    static /* synthetic */ String access$1200() {
        return DEFAULT_BORDER_COLOR;
    }

    static /* synthetic */ int access$1300() {
        return DEFAULT_BORDER_WIDTH;
    }

    static /* synthetic */ String access$1400() {
        return DEFAULT_BG_COLOR;
    }

    public static class ColorBarBuilder {
        ThicknessMode thicknessMode = ColorBar.access$000();
        double thickness = ColorBar.access$100();
        LenMode lenMode = ColorBar.access$200();
        double len = ColorBar.access$300();
        double x = ColorBar.access$400();
        int xPad = ColorBar.access$500();
        int yPad = ColorBar.access$600();
        double y = ColorBar.access$700();
        Xanchor xAnchor = ColorBar.access$800();
        Yanchor yAnchor = ColorBar.access$900();
        String outlineColor = ColorBar.access$1000();
        int outlineWidth = ColorBar.access$1100();
        String borderColor = ColorBar.access$1200();
        int borderWidth = ColorBar.access$1300();
        String bgColor = ColorBar.access$1400();
        TickSettings tickSettings;

        public ColorBarBuilder thickness(double thickness) {
            Preconditions.checkArgument((thickness >= 0.0 ? 1 : 0) != 0);
            this.thickness = thickness;
            return this;
        }

        public ColorBarBuilder len(double len) {
            Preconditions.checkArgument((len >= 0.0 ? 1 : 0) != 0);
            this.len = len;
            return this;
        }

        public ColorBarBuilder lenMode(LenMode lenMode) {
            this.lenMode = lenMode;
            return this;
        }

        public ColorBarBuilder thicknessMode(ThicknessMode mode) {
            this.thicknessMode = mode;
            return this;
        }

        public ColorBarBuilder x(double x) {
            Preconditions.checkArgument((x >= -2.0 && x <= 3.0 ? 1 : 0) != 0);
            this.x = x;
            return this;
        }

        public ColorBarBuilder y(double y) {
            Preconditions.checkArgument((y >= -2.0 && y <= 3.0 ? 1 : 0) != 0);
            this.y = y;
            return this;
        }

        public ColorBarBuilder xAnchor(Xanchor xAnchor) {
            this.xAnchor = xAnchor;
            return this;
        }

        public ColorBarBuilder yAnchor(Yanchor yAnchor) {
            this.yAnchor = yAnchor;
            return this;
        }

        public ColorBarBuilder yPad(int yPad) {
            Preconditions.checkArgument((yPad >= 0 ? 1 : 0) != 0);
            this.yPad = yPad;
            return this;
        }

        public ColorBarBuilder xPad(int xPad) {
            Preconditions.checkArgument((this.y >= 0.0 ? 1 : 0) != 0);
            this.xPad = xPad;
            return this;
        }

        public ColorBarBuilder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        public ColorBarBuilder borderColor(String color) {
            this.borderColor = color;
            return this;
        }

        public ColorBarBuilder bgColor(String color) {
            this.borderColor = color;
            return this;
        }

        public ColorBarBuilder borderWidth(int width) {
            Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0);
            this.borderWidth = width;
            return this;
        }

        public ColorBarBuilder outlineWidth(int width) {
            Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0);
            this.outlineWidth = width;
            return this;
        }

        public ColorBarBuilder tickSettings(TickSettings tickSettings) {
            this.tickSettings = tickSettings;
            return this;
        }
    }

    public static enum Yanchor {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private String value;

        private Yanchor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Xanchor {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        private String value;

        private Xanchor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum LenMode {
        FRACTION("fraction"),
        PIXELS("pixels");

        private String value;

        private LenMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ThicknessMode {
        FRACTION("fraction"),
        PIXELS("pixels");

        private String value;

        private ThicknessMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

