/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.worker;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.DispatchStrategy;
import tech.powerjob.common.model.DeployedContainerInfo;
import tech.powerjob.server.common.module.WorkerInfo;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.remote.server.redirector.DesignateServer;
import tech.powerjob.server.remote.worker.ClusterStatusHolder;
import tech.powerjob.server.remote.worker.WorkerClusterManagerService;
import tech.powerjob.server.remote.worker.filter.WorkerFilter;

@Service
public class WorkerClusterQueryService {
    private static final Logger log = LoggerFactory.getLogger(WorkerClusterQueryService.class);
    private final List<WorkerFilter> workerFilters;

    public WorkerClusterQueryService(List<WorkerFilter> workerFilters) {
        this.workerFilters = workerFilters;
    }

    public List<WorkerInfo> getSuitableWorkers(JobInfoDO jobInfo) {
        List workers = Lists.newLinkedList(this.getWorkerInfosByAppId(jobInfo.getAppId()).values());
        workers.removeIf(workerInfo -> this.filterWorker((WorkerInfo)workerInfo, jobInfo));
        DispatchStrategy dispatchStrategy = DispatchStrategy.of((Integer)jobInfo.getDispatchStrategy());
        switch (dispatchStrategy) {
            case RANDOM: {
                Collections.shuffle(workers);
                break;
            }
            case HEALTH_FIRST: {
                workers.sort((o1, o2) -> o2.getSystemMetrics().calculateScore() - o1.getSystemMetrics().calculateScore());
                break;
            }
        }
        if (!workers.isEmpty() && jobInfo.getMaxWorkerCount() > 0 && workers.size() > jobInfo.getMaxWorkerCount()) {
            workers = workers.subList(0, jobInfo.getMaxWorkerCount());
        }
        return workers;
    }

    @DesignateServer
    public List<WorkerInfo> getAllWorkers(Long appId) {
        LinkedList workers = Lists.newLinkedList(this.getWorkerInfosByAppId(appId).values());
        workers.sort((o1, o2) -> o2.getSystemMetrics().calculateScore() - o1.getSystemMetrics().calculateScore());
        return workers;
    }

    @DesignateServer
    public List<WorkerInfo> getAllAliveWorkers(Long appId) {
        LinkedList workers = Lists.newLinkedList(this.getWorkerInfosByAppId(appId).values());
        workers.removeIf(WorkerInfo::timeout);
        return workers;
    }

    public Optional<WorkerInfo> getWorkerInfoByAddress(Long appId, String address) {
        Map<String, WorkerInfo> workerInfosByAppId = this.getWorkerInfosByAppId(appId);
        if (null != workerInfosByAppId && null != address) {
            return Optional.ofNullable(workerInfosByAppId.get(address));
        }
        return Optional.empty();
    }

    public Map<Long, ClusterStatusHolder> getAppId2ClusterStatus() {
        return WorkerClusterManagerService.getAppId2ClusterStatus();
    }

    public List<DeployedContainerInfo> getDeployedContainerInfos(Long appId, Long containerId) {
        ClusterStatusHolder clusterStatusHolder = this.getAppId2ClusterStatus().get(appId);
        if (clusterStatusHolder == null) {
            return Collections.emptyList();
        }
        return clusterStatusHolder.getDeployedContainerInfos(containerId);
    }

    private Map<String, WorkerInfo> getWorkerInfosByAppId(Long appId) {
        ClusterStatusHolder clusterStatusHolder = this.getAppId2ClusterStatus().get(appId);
        if (clusterStatusHolder == null) {
            log.warn("[WorkerManagerService] can't find any worker for app(appId={}) yet.", (Object)appId);
            return Collections.emptyMap();
        }
        return clusterStatusHolder.getAllWorkers();
    }

    private boolean filterWorker(WorkerInfo workerInfo, JobInfoDO jobInfo) {
        for (WorkerFilter filter : this.workerFilters) {
            if (!filter.filter(workerInfo, jobInfo)) continue;
            return true;
        }
        return false;
    }
}

