/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.storage.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import tech.powerjob.common.enums.SwitchableStatus;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.common.spring.condition.PropertyAndOneBeanCondition;
import tech.powerjob.server.extension.dfs.DFsService;
import tech.powerjob.server.extension.dfs.DownloadRequest;
import tech.powerjob.server.extension.dfs.FileLocation;
import tech.powerjob.server.extension.dfs.FileMeta;
import tech.powerjob.server.extension.dfs.StoreRequest;
import tech.powerjob.server.persistence.storage.AbstractDFsService;

@Priority(value=0x7FFFFFFB)
@Conditional(value={PostgresqlSeriesCondition.class})
public class PostgresqlSeriesDfsService
extends AbstractDFsService {
    private static final Logger log = LoggerFactory.getLogger(PostgresqlSeriesDfsService.class);
    private DataSource dataSource;
    private static final String TYPE_POSTGRESQL = "postgresql_series";
    private static final String KEY_DRIVER_NAME = "driver";
    private static final String KEY_URL = "url";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_AUTO_CREATE_TABLE = "auto_create_table";
    private static final String KEY_TABLE_NAME = "table_name";
    private static final String DEFAULT_TABLE_NAME = "powerjob_files";
    private static final String POWERJOB_FILES_ID_SEQ = "CREATE SEQUENCE powerjob_files_id_seq\n    START WITH 1\n    INCREMENT BY 1\n    NO MINVALUE\n    NO MAXVALUE\n    CACHE 1;";
    private static final String CREATE_TABLE_SQL = "CREATE TABLE powerjob_files (\n  id bigint NOT NULL DEFAULT nextval('powerjob_files_id_seq') PRIMARY KEY,\n  bucket varchar(255) NOT NULL,\n  name varchar(255) NOT NULL,\n  version varchar(255) NOT NULL,\n  meta varchar(255) NULL DEFAULT NULL,\n  length bigint NOT NULL,\n  status int NOT NULL,\n  data bytea NOT NULL,\n  extra varchar(255) NULL DEFAULT NULL,\n  gmt_create timestamp without time zone NOT NULL,\n  gmt_modified timestamp without time zone NULL DEFAULT NULL\n);";
    private static final String INSERT_SQL = "insert into %s(bucket, name, version, meta, length, status, data, extra, gmt_create, gmt_modified) values (?,?,?,?,?,?,?,?,?,?);";
    private static final String DELETE_SQL = "DELETE FROM %s ";
    private static final String QUERY_FULL_SQL = "select * from %s";
    private static final String QUERY_META_SQL = "select bucket, name, version, meta, length, status, extra, gmt_create, gmt_modified from %s";

    private void deleteByLocation(FileLocation fileLocation) {
        String dSQLPrefix = this.fullSQL(DELETE_SQL);
        String dSQL = dSQLPrefix.concat(PostgresqlSeriesDfsService.whereSQL(fileLocation));
        this.executeDelete(dSQL);
    }

    private void executeDelete(String sql) {
        try (Connection con = this.dataSource.getConnection();){
            con.createStatement().executeUpdate(sql);
        }
        catch (Exception e) {
            log.error("[PostgresqlSeriesDfsService] executeDelete failed, sql: {}", (Object)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(StoreRequest storeRequest) throws IOException, SQLException {
        Stopwatch sw = Stopwatch.createStarted();
        String insertSQL = this.fullSQL(INSERT_SQL);
        FileLocation fileLocation = storeRequest.getFileLocation();
        this.deleteByLocation(fileLocation);
        HashMap meta = Maps.newHashMap();
        meta.put("_server_", this.serverInfo.getIp());
        meta.put("_local_file_path_", storeRequest.getLocalFile().getAbsolutePath());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(storeRequest.getLocalFile().toPath(), new OpenOption[0]));
        Date date = new Date(System.currentTimeMillis());
        Connection con = null;
        Statement pst = null;
        try {
            con = this.dataSource.getConnection();
            con.setAutoCommit(false);
            log.info("[PostgresqlSeriesDfsService] set autocommit false.");
            pst = con.prepareStatement(insertSQL);
            pst.setString(1, fileLocation.getBucket());
            pst.setString(2, fileLocation.getName());
            pst.setString(3, "mu");
            pst.setString(4, JsonUtils.toJSONString((Object)meta));
            pst.setLong(5, storeRequest.getLocalFile().length());
            pst.setInt(6, SwitchableStatus.ENABLE.getV());
            pst.setBytes(7, PostgresqlSeriesDfsService.bufferedInputStreamToByteArray(bufferedInputStream));
            pst.setString(8, null);
            pst.setDate(9, date);
            pst.setDate(10, date);
            pst.execute();
            con.commit();
            log.info("[PostgresqlSeriesDfsService] store [{}] successfully, cost: {}", (Object)fileLocation, (Object)sw);
        }
        catch (Exception e) {
            if (con != null) {
                con.rollback();
            }
            log.error("[PostgresqlSeriesDfsService] store [{}] failed!", (Object)fileLocation);
            ExceptionUtils.rethrow((Throwable)e);
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
                log.info("[PostgresqlSeriesDfsService] set autocommit true.");
                con.close();
            }
            if (null != pst) {
                pst.close();
            }
            bufferedInputStream.close();
        }
    }

    public static byte[] bufferedInputStreamToByteArray(BufferedInputStream bis) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (null == bis) {
            return null;
        }
        byte[] buffer = new byte[1024];
        while ((read = bis.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        bis.close();
        return baos.toByteArray();
    }

    public void download(DownloadRequest downloadRequest) throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        String querySQL = this.fullSQL(QUERY_FULL_SQL);
        FileLocation fileLocation = downloadRequest.getFileLocation();
        FileUtils.forceMkdirParent((File)downloadRequest.getTarget());
        try (Connection con = this.dataSource.getConnection();){
            ResultSet resultSet = con.createStatement().executeQuery(querySQL.concat(PostgresqlSeriesDfsService.whereSQL(fileLocation)));
            boolean exist = resultSet.next();
            if (!exist) {
                log.warn("[PostgresqlSeriesDfsService] download file[{}] failed due to not exits!", (Object)fileLocation);
                return;
            }
            Blob dataBlob = resultSet.getBlob("data");
            FileUtils.copyInputStreamToFile((InputStream)new BufferedInputStream(dataBlob.getBinaryStream()), (File)downloadRequest.getTarget());
            log.info("[PostgresqlSeriesDfsService] download [{}] successfully, cost: {}", (Object)fileLocation, (Object)sw);
        }
        catch (Exception e) {
            log.error("[PostgresqlSeriesDfsService] download file [{}] failed!", (Object)fileLocation, (Object)e);
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<FileMeta> fetchFileMeta(FileLocation fileLocation) {
        String querySQL = this.fullSQL(QUERY_META_SQL);
        try (Connection con = this.dataSource.getConnection();){
            ResultSet resultSet = con.createStatement().executeQuery(querySQL.concat(PostgresqlSeriesDfsService.whereSQL(fileLocation)));
            boolean exist = resultSet.next();
            if (!exist) {
                Optional<FileMeta> optional2 = Optional.empty();
                return optional2;
            }
            FileMeta fileMeta = new FileMeta().setLength(resultSet.getLong("length")).setLastModifiedTime((java.util.Date)resultSet.getDate("gmt_modified")).setMetaInfo(JsonUtils.parseMap((String)resultSet.getString("meta")));
            Optional<FileMeta> optional = Optional.of(fileMeta);
            return optional;
        }
        catch (Exception e) {
            log.error("[PostgresqlSeriesDfsService] fetchFileMeta [{}] failed!", (Object)fileLocation);
            ExceptionUtils.rethrow((Throwable)e);
            return Optional.empty();
        }
    }

    public void cleanExpiredFiles(String bucket, int days) {
        String dSQLPrefix = this.fullSQL(DELETE_SQL);
        long targetTs = DateUtils.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)(-days)).getTime();
        String targetDeleteTime = CommonUtils.formatTime((Long)targetTs);
        log.info("[PostgresqlSeriesDfsService] start to cleanExpiredFiles, targetDeleteTime: {}", (Object)targetDeleteTime);
        String fSQL = dSQLPrefix.concat(String.format(" where gmt_modified < '%s'", targetDeleteTime));
        log.info("[PostgresqlSeriesDfsService] cleanExpiredFiles SQL: {}", (Object)fSQL);
        this.executeDelete(fSQL);
    }

    @Override
    protected void init(ApplicationContext applicationContext) {
        Environment env = applicationContext.getEnvironment();
        PostgresqlProperty postgresqlProperty = new PostgresqlProperty().setDriver(PostgresqlSeriesDfsService.fetchProperty(env, TYPE_POSTGRESQL, KEY_DRIVER_NAME)).setUrl(PostgresqlSeriesDfsService.fetchProperty(env, TYPE_POSTGRESQL, KEY_URL)).setUsername(PostgresqlSeriesDfsService.fetchProperty(env, TYPE_POSTGRESQL, KEY_USERNAME)).setPassword(PostgresqlSeriesDfsService.fetchProperty(env, TYPE_POSTGRESQL, KEY_PASSWORD)).setAutoCreateTable(Boolean.TRUE.toString().equalsIgnoreCase(PostgresqlSeriesDfsService.fetchProperty(env, TYPE_POSTGRESQL, KEY_AUTO_CREATE_TABLE)));
        try {
            this.initDatabase(postgresqlProperty);
            this.initTable(postgresqlProperty);
        }
        catch (Exception e) {
            log.error("[PostgresqlSeriesDfsService] init datasource failed!", (Throwable)e);
            ExceptionUtils.rethrow((Throwable)e);
        }
        log.info("[PostgresqlSeriesDfsService] initialize successfully, THIS_WILL_BE_THE_STORAGE_LAYER.");
    }

    void initDatabase(PostgresqlProperty property) {
        log.info("[PostgresqlSeriesDfsService] init datasource by config: {}", (Object)property);
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(property.driver);
        config.setJdbcUrl(property.url);
        config.setUsername(property.username);
        config.setPassword(property.password);
        config.setAutoCommit(true);
        config.setMinimumIdle(2);
        config.setMaximumPoolSize(32);
        this.dataSource = new HikariDataSource(config);
    }

    void initTable(PostgresqlProperty property) throws Exception {
        if (property.autoCreateTable) {
            String powerjobFilesIdSeq = this.fullSQL(POWERJOB_FILES_ID_SEQ);
            String createTableSQL = this.fullSQL(CREATE_TABLE_SQL);
            log.info("[PostgresqlSeriesDfsService] use create table SQL: {}", (Object)createTableSQL);
            try (Connection connection = this.dataSource.getConnection();){
                connection.createStatement().execute(powerjobFilesIdSeq);
                connection.createStatement().execute(createTableSQL);
                log.info("[PostgresqlSeriesDfsService] auto create table successfully!");
            }
        }
    }

    private String fullSQL(String sql) {
        return String.format(sql, this.parseTableName());
    }

    private String parseTableName() {
        if (this.applicationContext == null) {
            return DEFAULT_TABLE_NAME;
        }
        String tableName = PostgresqlSeriesDfsService.fetchProperty(this.applicationContext.getEnvironment(), TYPE_POSTGRESQL, KEY_TABLE_NAME);
        return StringUtils.isEmpty((CharSequence)tableName) ? DEFAULT_TABLE_NAME : tableName;
    }

    private static String whereSQL(FileLocation fileLocation) {
        return String.format(" where bucket='%s' AND name='%s' ", fileLocation.getBucket(), fileLocation.getName());
    }

    public void destroy() throws Exception {
    }

    public static class PostgresqlSeriesCondition
    extends PropertyAndOneBeanCondition {
        protected List<String> anyConfigKey() {
            return Lists.newArrayList((Object[])new String[]{"oms.storage.dfs.postgresql_series.url"});
        }

        protected Class<?> beanType() {
            return DFsService.class;
        }
    }

    static class PostgresqlProperty {
        private String driver;
        private String url;
        private String username;
        private String password;
        private boolean autoCreateTable;

        public String getDriver() {
            return this.driver;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isAutoCreateTable() {
            return this.autoCreateTable;
        }

        public PostgresqlProperty setDriver(String driver) {
            this.driver = driver;
            return this;
        }

        public PostgresqlProperty setUrl(String url) {
            this.url = url;
            return this;
        }

        public PostgresqlProperty setUsername(String username) {
            this.username = username;
            return this;
        }

        public PostgresqlProperty setPassword(String password) {
            this.password = password;
            return this;
        }

        public PostgresqlProperty setAutoCreateTable(boolean autoCreateTable) {
            this.autoCreateTable = autoCreateTable;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PostgresqlProperty)) {
                return false;
            }
            PostgresqlProperty other = (PostgresqlProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driver = this.getDriver();
            String other$driver = other.getDriver();
            if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            return this.isAutoCreateTable() == other.isAutoCreateTable();
        }

        protected boolean canEqual(Object other) {
            return other instanceof PostgresqlProperty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driver = this.getDriver();
            result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            result = result * 59 + (this.isAutoCreateTable() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "PostgresqlSeriesDfsService.PostgresqlProperty(driver=" + this.getDriver() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", autoCreateTable=" + this.isAutoCreateTable() + ")";
        }
    }
}

