/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.storage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import tech.powerjob.server.common.aware.ServerInfoAware;
import tech.powerjob.server.common.module.ServerInfo;
import tech.powerjob.server.extension.dfs.DFsService;

public abstract class AbstractDFsService
implements DFsService,
ApplicationContextAware,
ServerInfoAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractDFsService.class);
    protected ServerInfo serverInfo;
    protected ApplicationContext applicationContext;
    protected static final String PROPERTY_KEY = "oms.storage.dfs";

    public AbstractDFsService() {
        log.info("[DFsService] invoke [{}]'s constructor", (Object)this.getClass().getName());
    }

    protected abstract void init(ApplicationContext var1);

    protected static String fetchProperty(Environment environment, String dfsType, String key) {
        String pKey = String.format("%s.%s.%s", PROPERTY_KEY, dfsType, key);
        return environment.getProperty(pKey);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        log.info("[DFsService] invoke [{}]'s setApplicationContext", (Object)this.getClass().getName());
        this.init(applicationContext);
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }
}

