/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence;

import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;

public class PageResult<T>
implements Serializable {
    private int index;
    private int pageSize;
    private int totalPages;
    private long totalItems;
    private List<T> data;

    public PageResult(Page<?> page) {
        this.index = page.getNumber();
        this.pageSize = page.getSize();
        this.totalPages = page.getTotalPages();
        this.totalItems = page.getTotalElements();
    }

    public int getIndex() {
        return this.index;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setTotalItems(long totalItems) {
        this.totalItems = totalItems;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getTotalItems() != other.getTotalItems()) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getTotalPages();
        long $totalItems = this.getTotalItems();
        result = result * 59 + (int)($totalItems >>> 32 ^ $totalItems);
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "PageResult(index=" + this.getIndex() + ", pageSize=" + this.getPageSize() + ", totalPages=" + this.getTotalPages() + ", totalItems=" + this.getTotalItems() + ", data=" + this.getData() + ")";
    }

    public PageResult() {
    }
}

