/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.migrate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.server.common.utils.SpringUtils;
import tech.powerjob.server.extension.LockService;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowNodeInfoDO;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowNodeInfoRepository;

@Service
public class V3ToV4MigrateService {
    private static final Logger log = LoggerFactory.getLogger(V3ToV4MigrateService.class);
    private static final String MIGRATE_LOCK_TEMPLATE = "v3to4MigrateLock-%s-%s";
    private final LockService lockService;
    private final JobInfoRepository jobInfoRepository;
    private final WorkflowInfoRepository workflowInfoRepository;
    private final WorkflowNodeInfoRepository workflowNodeInfoRepository;

    @Transactional(rollbackOn={Exception.class})
    public JSONObject fixDeprecatedProcessType(Long appId) {
        String lock = String.format(MIGRATE_LOCK_TEMPLATE, "fixDeprecatedProcessType", appId);
        boolean getLock = this.lockService.tryLock(lock, 120000L);
        if (!getLock) {
            throw new PowerJobException("get lock failed, maybe other migrate job is running");
        }
        try {
            JSONObject resultLog = new JSONObject();
            resultLog.put("docs", (Object)"https://www.yuque.com/powerjob/guidence/official_processor");
            resultLog.put("tips", (Object)"please add the maven dependency of 'powerjob-official-processors'");
            HashSet convertedJobIds = Sets.newHashSet();
            Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
                LinkedList predicates = Lists.newLinkedList();
                ArrayList scriptJobTypes = Lists.newArrayList((Object[])new Integer[]{ProcessorType.SHELL.getV(), ProcessorType.PYTHON.getV()});
                predicates.add(criteriaBuilder.equal((Expression)root.get("appId"), (Object)appId));
                predicates.add(root.get("processorType").in((Collection)scriptJobTypes));
                return query.where(predicates.toArray(new Predicate[0])).getRestriction();
            };
            List scriptJobs = this.jobInfoRepository.findAll((Specification)specification);
            resultLog.put("scriptJobsNum", (Object)scriptJobs.size());
            Stopwatch stopwatch = Stopwatch.createStarted();
            log.info("[FixDeprecatedProcessType] start to fix the job info whose processor type is deprecated,total number : {}", (Object)scriptJobs.size());
            scriptJobs.forEach(job -> {
                ProcessorType oldProcessorType = ProcessorType.of((int)job.getProcessorType());
                job.setJobParams(job.getProcessorInfo());
                job.setProcessorType(Integer.valueOf(ProcessorType.BUILT_IN.getV()));
                if (oldProcessorType == ProcessorType.PYTHON) {
                    job.setProcessorInfo("tech.powerjob.official.processors.impl.script.PythonProcessor");
                } else {
                    job.setProcessorInfo("tech.powerjob.official.processors.impl.script.ShellProcessor");
                }
                this.jobInfoRepository.saveAndFlush(job);
                convertedJobIds.add(job.getId());
            });
            resultLog.put("convertedJobIds", (Object)convertedJobIds);
            stopwatch.stop();
            log.info("[FixDeprecatedProcessType] fix the job info successfully,used time: {}s", (Object)stopwatch.elapsed(TimeUnit.SECONDS));
            JSONObject jSONObject = resultLog;
            return jSONObject;
        }
        catch (Exception e) {
            log.error("[FixDeprecatedProcessType] fail to fix the job info of app {}", (Object)appId, (Object)e);
            throw e;
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    public JSONObject fixWorkflowInfoFromV3ToV4(Long appId) {
        String lock = String.format(MIGRATE_LOCK_TEMPLATE, "fixWorkflowInfoFromV3ToV4", appId);
        boolean getLock = this.lockService.tryLock(lock, 180000L);
        if (!getLock) {
            throw new PowerJobException("get lock failed, maybe other migrate job is running");
        }
        try {
            JSONObject resultLog = new JSONObject();
            HashSet fixedWorkflowIds = Sets.newHashSet();
            List workflowInfoList = this.workflowInfoRepository.findByAppId(appId);
            resultLog.put("totalNum", (Object)workflowInfoList.size());
            Stopwatch stopwatch = Stopwatch.createStarted();
            log.info("[FixWorkflowInfoFromV3ToV4] start to fix the workflow info, total number : {}", (Object)workflowInfoList.size());
            HashMap<Long, Long> jobId2NodeIdMap = new HashMap<Long, Long>(64);
            HashMap<Long, String> failureReasonMap = new HashMap<Long, String>(workflowInfoList.size() / 2 + 1);
            for (WorkflowInfoDO workflowInfo : workflowInfoList) {
                try {
                    boolean fixed = ((V3ToV4MigrateService)SpringUtils.getBean(this.getClass())).fixWorkflowInfoCoreFromV3ToV4(workflowInfo, jobId2NodeIdMap);
                    if (fixed) {
                        fixedWorkflowIds.add(workflowInfo.getId());
                    }
                }
                catch (Exception e) {
                    failureReasonMap.put(workflowInfo.getId(), e.toString());
                }
                jobId2NodeIdMap.clear();
            }
            stopwatch.stop();
            log.info("[FixWorkflowInfoFromV3ToV4] fix the workflow info successfully, total number : {}, fixed number : {}, used time: {}s", new Object[]{workflowInfoList.size(), fixedWorkflowIds.size(), stopwatch.elapsed(TimeUnit.SECONDS)});
            resultLog.put("fixedWorkflowIds", (Object)fixedWorkflowIds);
            resultLog.put("failureWorkflowInfo", failureReasonMap);
            JSONObject jSONObject = resultLog;
            return jSONObject;
        }
        catch (Exception e) {
            log.error("[FixWorkflowInfoFromV3ToV4] fail to fix the workflow info of app {}", (Object)appId, (Object)e);
            throw e;
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public boolean fixWorkflowInfoCoreFromV3ToV4(WorkflowInfoDO workflowInfo, Map<Long, Long> jobId2NodeIdMap) {
        PEWorkflowDAG peDag;
        String dag = workflowInfo.getPeDAG();
        try {
            peDag = (PEWorkflowDAG)JSON.parseObject((String)dag, PEWorkflowDAG.class);
        }
        catch (Exception e) {
            throw new PowerJobException("invalid DAG!");
        }
        if (peDag == null || CollectionUtils.isEmpty((Collection)peDag.getNodes())) {
            return false;
        }
        boolean needFix = false;
        boolean existNodeId = false;
        for (PEWorkflowDAG.Node node : peDag.getNodes()) {
            if (node.getNodeId() == null) {
                needFix = true;
                continue;
            }
            existNodeId = true;
        }
        if (needFix && existNodeId) {
            throw new PowerJobException("sorry,we can't fix this workflow info automatically whose node info is wrong! you need to fix them by yourself.");
        }
        if (!needFix) {
            return false;
        }
        for (PEWorkflowDAG.Node node : peDag.getNodes()) {
            JobInfoDO jobInfo = (JobInfoDO)this.jobInfoRepository.findById((Object)node.getJobId()).orElseThrow(() -> new PowerJobException("can't find job by id " + node.getJobId()));
            WorkflowNodeInfoDO nodeInfo = new WorkflowNodeInfoDO();
            nodeInfo.setWorkflowId(workflowInfo.getId());
            nodeInfo.setAppId(workflowInfo.getAppId());
            nodeInfo.setJobId(jobInfo.getId());
            nodeInfo.setNodeName(jobInfo.getJobName());
            nodeInfo.setNodeParams(jobInfo.getJobParams());
            nodeInfo.setEnable(Boolean.valueOf(true));
            nodeInfo.setSkipWhenFailed(Boolean.valueOf(false));
            nodeInfo.setGmtCreate(new Date());
            nodeInfo.setGmtModified(new Date());
            nodeInfo = (WorkflowNodeInfoDO)this.workflowNodeInfoRepository.saveAndFlush((Object)nodeInfo);
            node.setNodeId(nodeInfo.getId());
            node.setNodeName(nodeInfo.getNodeName());
            jobId2NodeIdMap.put(node.getJobId(), node.getNodeId());
        }
        if (!CollectionUtils.isEmpty((Collection)peDag.getEdges())) {
            for (PEWorkflowDAG.Edge edge : peDag.getEdges()) {
                edge.setFrom(jobId2NodeIdMap.get(edge.getFrom()));
                edge.setTo(jobId2NodeIdMap.get(edge.getTo()));
            }
        }
        workflowInfo.setPeDAG(JSON.toJSONString((Object)peDag));
        workflowInfo.setGmtModified(new Date());
        this.workflowInfoRepository.saveAndFlush((Object)workflowInfo);
        return true;
    }

    public V3ToV4MigrateService(LockService lockService, JobInfoRepository jobInfoRepository, WorkflowInfoRepository workflowInfoRepository, WorkflowNodeInfoRepository workflowNodeInfoRepository) {
        this.lockService = lockService;
        this.jobInfoRepository = jobInfoRepository;
        this.workflowInfoRepository = workflowInfoRepository;
        this.workflowNodeInfoRepository = workflowNodeInfoRepository;
    }
}

