/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.common.utils;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import tech.powerjob.common.utils.DigestUtils;

public class AESUtil {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int KEY_SIZE = 256;
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static final SecureRandom secureRandom = new SecureRandom();

    private static SecretKeySpec getKey(String key) {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        if (keyBytes.length != 32) {
            keyBytes = DigestUtils.md5((String)key).getBytes(StandardCharsets.UTF_8);
        }
        return new SecretKeySpec(keyBytes, ALGORITHM);
    }

    public static String encrypt(String data, String key) {
        byte[] nonce = new byte[12];
        secureRandom.nextBytes(nonce);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, nonce);
        cipher.init(1, (Key)AESUtil.getKey(key), gcmParameterSpec);
        byte[] encryptedData = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        byte[] combinedData = new byte[nonce.length + encryptedData.length];
        System.arraycopy(nonce, 0, combinedData, 0, nonce.length);
        System.arraycopy(encryptedData, 0, combinedData, nonce.length, encryptedData.length);
        return Base64.getEncoder().encodeToString(combinedData);
    }

    public static String decrypt(String encryptedData, String key) {
        byte[] combinedData = Base64.getDecoder().decode(encryptedData);
        byte[] nonce = new byte[12];
        System.arraycopy(combinedData, 0, nonce, 0, nonce.length);
        byte[] encryptedText = new byte[combinedData.length - nonce.length];
        System.arraycopy(combinedData, nonce.length, encryptedText, 0, encryptedText.length);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, nonce);
        cipher.init(2, (Key)AESUtil.getKey(key), gcmParameterSpec);
        byte[] decryptedData = cipher.doFinal(encryptedText);
        return new String(decryptedData, StandardCharsets.UTF_8);
    }
}

