/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.http.vertx;

import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.utils.SysUtils;

public class VertxInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VertxInitializer.class);
    private static final int DEFAULT_KEEP_ALIVE_TIMEOUT = 75;
    private static final int CONNECTION_TIMEOUT_MS = 3000;
    private static final int SERVER_IDLE_TIMEOUT_S = 300;

    public static Vertx buildVertx() {
        int cpuCores = SysUtils.availableProcessors();
        VertxOptions options = new VertxOptions().setWorkerPoolSize(Math.max(16, 2 * cpuCores)).setInternalBlockingPoolSize(Math.max(32, 4 * cpuCores));
        log.info("[PowerJob-Vertx] use vertx options: {}", (Object)options);
        return Vertx.vertx((VertxOptions)options);
    }

    public static HttpServer buildHttpServer(Vertx vertx) {
        HttpServerOptions httpServerOptions = new HttpServerOptions().setIdleTimeout(300);
        VertxInitializer.tryEnableCompression(httpServerOptions);
        log.info("[PowerJob-Vertx] use HttpServerOptions: {}", (Object)httpServerOptions.toJson());
        return vertx.createHttpServer(httpServerOptions);
    }

    private static void tryEnableCompression(HttpServerOptions httpServerOptions) {
        try {
            httpServerOptions.addCompressor((CompressionOptions)StandardCompressionOptions.gzip()).setCompressionSupported(true);
            log.warn("[PowerJob-Vertx] enable server side compression successfully!");
        }
        catch (Throwable t) {
            log.warn("[PowerJob-Vertx] enable server side compression failed. The error is not fatal, but performance may be degraded", t);
        }
    }

    public static HttpClient buildHttpClient(Vertx vertx) {
        HttpClientOptions httpClientOptions = new HttpClientOptions().setMetricsName("tech.powerjob").setConnectTimeout(3000).setMaxPoolSize(Math.max(8, SysUtils.availableProcessors()) * 2);
        String keepaliveTimeout = System.getProperty("powerjob.transporter.keepalive.timeout", String.valueOf(75));
        int keepaliveTimeoutInt = Integer.parseInt(keepaliveTimeout);
        if (keepaliveTimeoutInt > 0) {
            httpClientOptions.setKeepAlive(true).setKeepAliveTimeout(keepaliveTimeoutInt);
        } else {
            httpClientOptions.setKeepAlive(false);
        }
        String enableCompressing = System.getProperty("powerjob.transporter.compression.enabled");
        if (StringUtils.isNotEmpty((CharSequence)enableCompressing)) {
            httpClientOptions.setTryUseCompression(StringUtils.equalsIgnoreCase((CharSequence)enableCompressing, (CharSequence)Boolean.TRUE.toString()));
        }
        log.info("[PowerJob-Vertx] use HttpClientOptions: {}", (Object)httpClientOptions.toJson());
        return vertx.createHttpClient(httpClientOptions);
    }
}

