/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.plugin;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.refaster.RefasterRuleBuilderScanner;
import com.google.errorprone.refaster.UTemplater;
import com.google.errorprone.refaster.annotation.BeforeTemplate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.refaster.AnnotatedCompositeCodeTransformer;

final class RefasterRuleCompilerTaskListener
implements TaskListener {
    private final Context context;

    RefasterRuleCompilerTaskListener(Context context) {
        this.context = context;
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() != TaskEvent.Kind.ANALYZE || JavaCompiler.instance(this.context).errorCount() > 0) {
            return;
        }
        JCTree.JCClassDecl tree = JavacTrees.instance(this.context).getTree(taskEvent.getTypeElement());
        if (tree == null || !RefasterRuleCompilerTaskListener.containsRefasterRules(tree)) {
            return;
        }
        ImmutableMap<ClassTree, CodeTransformer> rules = this.compileRefasterRules(tree);
        for (Map.Entry rule : rules.entrySet()) {
            try {
                RefasterRuleCompilerTaskListener.outputCodeTransformer((CodeTransformer)rule.getValue(), this.getOutputFile(taskEvent, (ClassTree)rule.getKey()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to persist compiled Refaster rules", e);
            }
        }
    }

    private ImmutableMap<ClassTree, CodeTransformer> compileRefasterRules(ClassTree tree) {
        final ImmutableMap.Builder rules = ImmutableMap.builder();
        new TreeScanner<Void, ImmutableClassToInstanceMap<Annotation>>(this){
            final /* synthetic */ RefasterRuleCompilerTaskListener this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public @Nullable Void visitClass(ClassTree node, ImmutableClassToInstanceMap<Annotation> annotations) {
                Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)node);
                ImmutableList transformers = ImmutableList.copyOf((Collection)RefasterRuleBuilderScanner.extractRules((ClassTree)node, (Context)this.this$0.context));
                if (!transformers.isEmpty()) {
                    rules.put((Object)node, (Object)new AnnotatedCompositeCodeTransformer(RefasterRuleCompilerTaskListener.toPackageName(symbol), transformers, annotations));
                }
                return (Void)super.visitClass(node, RefasterRuleCompilerTaskListener.merge(annotations, (ImmutableClassToInstanceMap<Annotation>)UTemplater.annotationMap((Symbol)symbol)));
            }
        }.scan(tree, ImmutableClassToInstanceMap.of());
        return rules.buildOrThrow();
    }

    private FileObject getOutputFile(TaskEvent taskEvent, ClassTree tree) throws IOException {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        JavaFileManager fileManager = this.context.get(JavaFileManager.class);
        return fileManager.getFileForOutput(StandardLocation.CLASS_OUTPUT, RefasterRuleCompilerTaskListener.toPackageName(symbol), RefasterRuleCompilerTaskListener.toSimpleFlatName(symbol) + ".refaster", taskEvent.getSourceFile());
    }

    private static boolean containsRefasterRules(ClassTree tree) {
        return Boolean.TRUE.equals(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitAnnotation(AnnotationTree node, @Nullable Void unused) {
                Symbol sym = ASTHelpers.getSymbol((Tree)node);
                return sym != null && sym.getQualifiedName().contentEquals(BeforeTemplate.class.getCanonicalName()) || (Boolean)super.visitAnnotation(node, null) != false;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return Boolean.TRUE.equals(r1) || Boolean.TRUE.equals(r2);
            }
        }.scan(tree, null));
    }

    private static ImmutableClassToInstanceMap<Annotation> merge(ImmutableClassToInstanceMap<Annotation> first, ImmutableClassToInstanceMap<Annotation> second) {
        return ImmutableClassToInstanceMap.builder().putAll(Maps.filterKeys(first, k -> !second.containsKey(k))).putAll(second).build();
    }

    private static String toPackageName(Symbol.ClassSymbol symbol) {
        Symbol.PackageSymbol enclosingPackage = ASTHelpers.enclosingPackage((Symbol)symbol);
        return enclosingPackage == null ? "" : enclosingPackage.toString();
    }

    private static String toSimpleFlatName(Symbol.ClassSymbol symbol) {
        String flatName = symbol.flatName().toString();
        int lastDot = flatName.lastIndexOf(46);
        return lastDot < 0 ? flatName : flatName.substring(lastDot + 1);
    }

    private static void outputCodeTransformer(CodeTransformer codeTransformer, FileObject target) throws IOException {
        try (ObjectOutputStream output = new ObjectOutputStream(target.openOutputStream());){
            output.writeObject(codeTransformer);
        }
    }
}

