/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap.metric;

import java.util.HashMap;
import java.util.Map;
import tagbio.umap.metric.BrayCurtisMetric;
import tagbio.umap.metric.CanberraMetric;
import tagbio.umap.metric.ChebyshevMetric;
import tagbio.umap.metric.CorrelationMetric;
import tagbio.umap.metric.CosineMetric;
import tagbio.umap.metric.DiceMetric;
import tagbio.umap.metric.EuclideanMetric;
import tagbio.umap.metric.HammingMetric;
import tagbio.umap.metric.HaversineMetric;
import tagbio.umap.metric.JaccardMetric;
import tagbio.umap.metric.KulsinskiMetric;
import tagbio.umap.metric.ManhattanMetric;
import tagbio.umap.metric.MatchingMetric;
import tagbio.umap.metric.RogersTanimotoMetric;
import tagbio.umap.metric.RussellRaoMetric;
import tagbio.umap.metric.SokalMichenerMetric;
import tagbio.umap.metric.SokalSneathMetric;
import tagbio.umap.metric.YuleMetric;

public abstract class Metric {
    private final boolean mIsAngular;
    private static Map<String, Metric> sMETRICS = null;

    Metric(boolean isAngular) {
        this.mIsAngular = isAngular;
    }

    public abstract float distance(float[] var1, float[] var2);

    public boolean isAngular() {
        return this.mIsAngular;
    }

    public static Metric getMetric(String name) {
        Metric m;
        if (sMETRICS == null) {
            sMETRICS = new HashMap<String, Metric>();
            sMETRICS.put("euclidean", EuclideanMetric.SINGLETON);
            sMETRICS.put("l2", EuclideanMetric.SINGLETON);
            sMETRICS.put("manhattan", ManhattanMetric.SINGLETON);
            sMETRICS.put("l1", ManhattanMetric.SINGLETON);
            sMETRICS.put("taxicab", ManhattanMetric.SINGLETON);
            sMETRICS.put("chebyshev", ChebyshevMetric.SINGLETON);
            sMETRICS.put("linfinity", ChebyshevMetric.SINGLETON);
            sMETRICS.put("linfty", ChebyshevMetric.SINGLETON);
            sMETRICS.put("linf", ChebyshevMetric.SINGLETON);
            sMETRICS.put("canberra", CanberraMetric.SINGLETON);
            sMETRICS.put("cosine", CosineMetric.SINGLETON);
            sMETRICS.put("correlation", CorrelationMetric.SINGLETON);
            sMETRICS.put("haversine", HaversineMetric.SINGLETON);
            sMETRICS.put("braycurtis", BrayCurtisMetric.SINGLETON);
            sMETRICS.put("hamming", HammingMetric.SINGLETON);
            sMETRICS.put("jaccard", JaccardMetric.SINGLETON);
            sMETRICS.put("dice", DiceMetric.SINGLETON);
            sMETRICS.put("matching", MatchingMetric.SINGLETON);
            sMETRICS.put("kulsinski", KulsinskiMetric.SINGLETON);
            sMETRICS.put("rogerstanimoto", RogersTanimotoMetric.SINGLETON);
            sMETRICS.put("russellrao", RussellRaoMetric.SINGLETON);
            sMETRICS.put("sokalsneath", SokalSneathMetric.SINGLETON);
            sMETRICS.put("sokalmichener", SokalMichenerMetric.SINGLETON);
            sMETRICS.put("yule", YuleMetric.SINGLETON);
        }
        if ((m = sMETRICS.get(name.toLowerCase())) == null) {
            throw new IllegalArgumentException("Unknown metric: " + name);
        }
        return m;
    }
}

