/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Arrays;
import tagbio.umap.CsrMatrix;
import tagbio.umap.DefaultMatrix;
import tagbio.umap.Matrix;

class CooMatrix
extends Matrix {
    private final int[] mRow;
    private final int[] mCol;
    private final float[] mData;

    private static CooMatrix createWithTruncate(float[] d, int[] r, int[] c, int rows, int cols, int len) {
        return len == r.length ? new CooMatrix(d, r, c, rows, cols) : new CooMatrix(Arrays.copyOf(d, len), Arrays.copyOf(r, len), Arrays.copyOf(c, len), rows, cols);
    }

    CooMatrix(float[] vals, int[] rows, int[] cols, int rowCount, int colCount) {
        super(rowCount, colCount);
        if (rows.length != cols.length || rows.length != vals.length) {
            throw new IllegalArgumentException();
        }
        this.mRow = rows;
        this.mCol = cols;
        this.mData = vals;
        this.sort(0, rows.length);
        this.checkDataValid();
    }

    private void checkDataValid() {
        for (int r : this.mRow) {
            if (r >= 0 && r < this.rows()) continue;
            throw new IllegalArgumentException("Row index out of bounds: 0 <= " + r + " < " + this.rows());
        }
        for (int c : this.mCol) {
            if (c >= 0 && c < this.cols()) continue;
            throw new IllegalArgumentException("Column index out of bounds: 0 <= " + c + " < " + this.cols());
        }
        for (int i = 1; i < this.mRow.length; ++i) {
            if (this.compare(i, i - 1) != 0) continue;
            throw new IllegalArgumentException("Duplicated array position: row " + this.mRow[i] + ", col " + this.mCol[i]);
        }
    }

    private void swap(int a, int b) {
        int t = this.mRow[a];
        this.mRow[a] = this.mRow[b];
        this.mRow[b] = t;
        int u = this.mCol[a];
        this.mCol[a] = this.mCol[b];
        this.mCol[b] = u;
        float v = this.mData[a];
        this.mData[a] = this.mData[b];
        this.mData[b] = v;
    }

    private int compare(int i, int j) {
        return this.compare(i, this.mRow[j], this.mCol[j]);
    }

    private int compare(int i, int r, int c) {
        int res = Integer.compare(this.mRow[i], r);
        if (res == 0) {
            res = Integer.compare(this.mCol[i], c);
        }
        return res;
    }

    private void sort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compare(j - 1, j) > 0; --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len != 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        int vr = this.mRow[m];
        int vc = this.mCol[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.compare(b, vr, vc) <= 0) {
                if (this.compare(b, vr, vc) >= 0) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.compare(c, vr, vc) >= 0) {
                if (this.compare(c, vr, vc) <= 0) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n2 = off + len;
        int s2 = Math.min(a - off, b - a);
        this.vecswap(off, b - s2, s2);
        s2 = Math.min(d - c, n2 - d - 1);
        this.vecswap(b, n2 - s2, s2);
        s2 = b - a;
        if (s2 > 1) {
            this.sort(off, s2);
        }
        if ((s2 = d - c) > 1) {
            this.sort(n2 - s2, s2);
        }
    }

    private void vecswap(int aa, int bb, int n) {
        int i = 0;
        int a = aa;
        int b = bb;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    int med3(int a, int b, int c) {
        int ab = this.compare(a, b);
        int ac = this.compare(a, c);
        int bc = this.compare(b, c);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    float[] data() {
        return Arrays.copyOf(this.mData, this.mData.length);
    }

    int[] row() {
        return Arrays.copyOf(this.mRow, this.mRow.length);
    }

    int[] col() {
        return Arrays.copyOf(this.mCol, this.mCol.length);
    }

    @Override
    float get(int r, int c) {
        int left = 0;
        int right = this.mRow.length - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            if (this.mRow[mid] == r) {
                if (this.mCol[mid] == c) {
                    return this.mData[mid];
                }
                if (this.mCol[mid] < c) {
                    left = mid + 1;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (this.mRow[mid] < r) {
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        return 0.0f;
    }

    @Override
    void set(int row, int col, float val) {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean isFinite() {
        for (float v : this.mData) {
            if (Float.isFinite(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    Matrix copy() {
        return new CooMatrix(Arrays.copyOf(this.mData, this.mData.length), Arrays.copyOf(this.mRow, this.mRow.length), Arrays.copyOf(this.mCol, this.mCol.length), this.rows(), this.cols());
    }

    @Override
    Matrix transpose() {
        return new CooMatrix(Arrays.copyOf(this.mData, this.mData.length), Arrays.copyOf(this.mCol, this.mCol.length), Arrays.copyOf(this.mRow, this.mRow.length), this.cols(), this.rows());
    }

    @Override
    CooMatrix toCoo() {
        return this;
    }

    @Override
    CsrMatrix toCsr() {
        int[] indptr = new int[this.rows() + 1];
        int r = -1;
        for (int k = 0; k < this.mData.length; ++k) {
            while (this.mRow[k] > r) {
                indptr[++r] = k;
            }
        }
        indptr[this.rows()] = this.mData.length;
        return new CsrMatrix(Arrays.copyOf(this.mData, this.mData.length), indptr, Arrays.copyOf(this.mCol, this.mCol.length), this.rows(), this.cols());
    }

    @Override
    Matrix eliminateZeros() {
        int zeros = 0;
        for (float v : this.mData) {
            if (v != 0.0f) continue;
            ++zeros;
        }
        if (zeros > 0) {
            int[] r = new int[this.mRow.length - zeros];
            int[] c = new int[this.mRow.length - zeros];
            float[] d = new float[this.mRow.length - zeros];
            int j = 0;
            for (int k = 0; k < this.mData.length; ++k) {
                if (this.mData[k] == 0.0f) continue;
                r[j] = this.mRow[k];
                c[j] = this.mCol[k];
                d[j++] = this.mData[k];
            }
            return new CooMatrix(d, r, c, this.rows(), this.cols());
        }
        return this;
    }

    private int getMaxNonZeroSize() {
        long mnz = Math.min((long)this.rows() * (long)this.cols(), 2L * (long)this.mRow.length);
        if (mnz > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Implementation limits exceeded");
        }
        return (int)mnz;
    }

    @Override
    Matrix add(Matrix matrix) {
        if (!(matrix instanceof CooMatrix)) {
            return super.add(matrix).toCoo();
        }
        CooMatrix m = (CooMatrix)matrix;
        if (!this.isShapeSame(m)) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        int maxNonZero = this.getMaxNonZeroSize();
        int[] r = new int[maxNonZero];
        int[] c = new int[maxNonZero];
        float[] d = new float[maxNonZero];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < this.mData.length && j < m.mData.length) {
            float s;
            int ri = this.mRow[i];
            int rj = m.mRow[j];
            if (ri < rj) {
                r[k] = ri;
                c[k] = this.mCol[i];
                d[k++] = this.mData[i++];
                continue;
            }
            if (rj < ri) {
                r[k] = rj;
                c[k] = m.mCol[j];
                d[k++] = -m.mData[j++];
                continue;
            }
            assert (ri == rj);
            int ci = this.mCol[i];
            int cj = m.mCol[j];
            if (ci < cj) {
                r[k] = ri;
                c[k] = ci;
                d[k++] = this.mData[i++];
                continue;
            }
            if (cj < ci) {
                r[k] = rj;
                c[k] = cj;
                d[k++] = m.mData[j++];
                continue;
            }
            assert (ci == cj);
            if ((s = this.mData[i++] + m.mData[j++]) == 0.0f) continue;
            r[k] = rj;
            c[k] = cj;
            d[k++] = s;
        }
        while (i < this.mData.length) {
            r[k] = this.mRow[i];
            c[k] = this.mCol[i];
            d[k++] = this.mData[i++];
        }
        while (j < m.mData.length) {
            r[k] = m.mRow[j];
            c[k] = m.mCol[j];
            d[k++] = m.mData[j++];
        }
        return CooMatrix.createWithTruncate(d, r, c, this.rows(), this.cols(), k);
    }

    @Override
    Matrix subtract(Matrix matrix) {
        if (!(matrix instanceof CooMatrix)) {
            return super.subtract(matrix).toCoo();
        }
        CooMatrix m = (CooMatrix)matrix;
        if (!this.isShapeSame(m)) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        int maxNonZero = this.getMaxNonZeroSize();
        int[] r = new int[maxNonZero];
        int[] c = new int[maxNonZero];
        float[] d = new float[maxNonZero];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < this.mData.length && j < m.mData.length) {
            float s;
            int ri = this.mRow[i];
            int rj = m.mRow[j];
            if (ri < rj) {
                r[k] = ri;
                c[k] = this.mCol[i];
                d[k++] = this.mData[i++];
                continue;
            }
            if (rj < ri) {
                r[k] = rj;
                c[k] = m.mCol[j];
                d[k++] = -m.mData[j++];
                continue;
            }
            assert (ri == rj);
            int ci = this.mCol[i];
            int cj = m.mCol[j];
            if (ci < cj) {
                r[k] = ri;
                c[k] = ci;
                d[k++] = this.mData[i++];
                continue;
            }
            if (cj < ci) {
                r[k] = rj;
                c[k] = cj;
                d[k++] = -m.mData[j++];
                continue;
            }
            assert (ci == cj);
            if ((s = this.mData[i++] - m.mData[j++]) == 0.0f) continue;
            r[k] = rj;
            c[k] = cj;
            d[k++] = s;
        }
        while (i < this.mData.length) {
            r[k] = this.mRow[i];
            c[k] = this.mCol[i];
            d[k++] = this.mData[i++];
        }
        while (j < m.mData.length) {
            r[k] = m.mRow[j];
            c[k] = m.mCol[j];
            d[k++] = -m.mData[j++];
        }
        return CooMatrix.createWithTruncate(d, r, c, this.rows(), this.cols(), k);
    }

    @Override
    Matrix hadamardMultiply(Matrix matrix) {
        if (!(matrix instanceof CooMatrix)) {
            return super.hadamardMultiply(matrix).toCoo();
        }
        CooMatrix m = (CooMatrix)matrix;
        if (!this.isShapeSame(m)) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        int maxNonZero = Math.max(this.mRow.length, m.mRow.length);
        int[] r = new int[maxNonZero];
        int[] c = new int[maxNonZero];
        float[] d = new float[maxNonZero];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < this.mData.length && j < m.mData.length) {
            float s;
            int ri = this.mRow[i];
            int rj = m.mRow[j];
            if (ri < rj) {
                ++i;
                continue;
            }
            if (rj < ri) {
                ++j;
                continue;
            }
            assert (ri == rj);
            int ci = this.mCol[i];
            int cj = m.mCol[j];
            if (ci < cj) {
                ++i;
                continue;
            }
            if (cj < ci) {
                ++j;
                continue;
            }
            assert (ci == cj);
            if ((s = this.mData[i++] * m.mData[j++]) == 0.0f) continue;
            r[k] = rj;
            c[k] = cj;
            d[k++] = s;
        }
        return CooMatrix.createWithTruncate(d, r, c, this.rows(), this.cols(), k);
    }

    @Override
    Matrix hadamardMultiplyTranspose() {
        if (this.rows() != this.cols()) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        int[] r = new int[this.mRow.length];
        int[] c = new int[this.mCol.length];
        float[] d = new float[this.mData.length];
        int j = 0;
        for (int k = 0; k < this.mRow.length; ++k) {
            float v = this.mData[k] * this.get(this.mCol[k], this.mRow[k]);
            if (v == 0.0f) continue;
            r[j] = this.mRow[k];
            c[j] = this.mCol[k];
            d[j++] = v;
        }
        return CooMatrix.createWithTruncate(d, r, c, this.rows(), this.cols(), j);
    }

    @Override
    Matrix addTranspose() {
        if (this.rows() != this.cols()) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        int maxNonZero = this.getMaxNonZeroSize();
        int[] r = new int[maxNonZero];
        int[] c = new int[maxNonZero];
        float[] d = new float[maxNonZero];
        int j = 0;
        for (int k = 0; k < this.mRow.length; ++k) {
            int ck = this.mCol[k];
            int rk = this.mRow[k];
            float tk = this.get(ck, rk);
            float v = this.mData[k] + tk;
            if (v == 0.0f) continue;
            r[j] = rk;
            c[j] = ck;
            d[j++] = v;
            if (rk == ck || tk != 0.0f) continue;
            r[j] = ck;
            c[j] = rk;
            d[j++] = v;
        }
        return CooMatrix.createWithTruncate(d, r, c, this.rows(), this.cols(), j);
    }

    @Override
    Matrix multiply(Matrix m) {
        if (!(m instanceof CooMatrix)) {
            return super.multiply(m).toCoo();
        }
        CooMatrix a = (CooMatrix)m;
        if (this.cols() != m.rows()) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        int rows = this.rows();
        int cols = m.cols();
        float[][] res = new float[rows][cols];
        for (int k = 0; k < this.mData.length; ++k) {
            int r = this.mRow[k];
            int c = this.mCol[k];
            for (int j = 0; j < a.mData.length; ++j) {
                if (a.mRow[j] != c) continue;
                float[] fArray = res[r];
                int n = a.mCol[j];
                fArray[n] = fArray[n] + this.mData[k] * a.mData[j];
            }
        }
        return new DefaultMatrix(res).toCoo();
    }

    @Override
    Matrix multiply(float x) {
        float[] newData = new float[this.mData.length];
        for (int i = 0; i < newData.length; ++i) {
            newData[i] = this.mData[i] * x;
        }
        return new CooMatrix(newData, this.mRow, this.mCol, this.rows(), this.cols());
    }

    String sparseToString() {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < this.mData.length; ++k) {
            sb.append('(').append(this.mRow[k]).append(", ").append(this.mCol[k]).append(") ").append(this.mData[k]).append('\n');
        }
        return sb.toString();
    }

    @Override
    Matrix rowNormalize() {
        float[] d = new float[this.mData.length];
        int row = -1;
        float max = 0.0f;
        for (int k = 0; k < this.mRow.length; ++k) {
            if (this.mRow[k] != row) {
                row = this.mRow[k];
                max = this.mData[k];
                for (int j = k + 1; j < this.mRow.length && this.mRow[j] == this.mRow[k]; ++j) {
                    max = Math.max(max, this.mData[j]);
                }
            }
            if (max == 0.0f) continue;
            d[k] = this.mData[k] / max;
        }
        return new CooMatrix(d, Arrays.copyOf(this.mRow, this.mRow.length), Arrays.copyOf(this.mCol, this.mCol.length), this.rows(), this.cols());
    }

    void fastIntersection(float[] target, float unknownDist, float farDist) {
        for (int nz = 0; nz < this.mRow.length; ++nz) {
            int i = this.mRow[nz];
            int j = this.mCol[nz];
            if (target[i] == -1.0f || target[j] == -1.0f) {
                int n = nz;
                this.mData[n] = (float)((double)this.mData[n] * Math.exp(-unknownDist));
                continue;
            }
            if (target[i] == target[j]) continue;
            int n = nz;
            this.mData[n] = (float)((double)this.mData[n] * Math.exp(-farDist));
        }
    }
}

