/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.ArrayList;
import java.util.List;
import tagbio.umap.ProgressListener;
import tagbio.umap.ProgressState;
import tagbio.umap.Utils;

public final class UmapProgress {
    private static final UmapProgress PROGRESS = new UmapProgress();
    private static final long MIN_UPDATE_PERIOD = 500L;
    private final List<ProgressListener> mProgressListeners = new ArrayList<ProgressListener>();
    private int mTotal = 0;
    private int mCounter = 0;
    private long mLastNotificationTime = 0L;

    private UmapProgress() {
    }

    public static synchronized void addProgressListener(ProgressListener listener) {
        if (!UmapProgress.PROGRESS.mProgressListeners.contains(listener)) {
            UmapProgress.PROGRESS.mProgressListeners.add(listener);
        }
    }

    public static synchronized boolean removeProgressListener(ProgressListener listener) {
        return UmapProgress.PROGRESS.mProgressListeners.remove(listener);
    }

    protected void notifyListeners(ProgressState state) {
        long now = System.currentTimeMillis();
        if (now - this.mLastNotificationTime > 500L) {
            for (ProgressListener listener : this.mProgressListeners) {
                listener.updated(state);
            }
            this.mLastNotificationTime = now;
        }
    }

    public static synchronized void reset(int total) {
        UmapProgress.PROGRESS.mTotal = total;
        UmapProgress.PROGRESS.mCounter = 0;
        UmapProgress.PROGRESS.mLastNotificationTime = 0L;
        UmapProgress.update(0);
    }

    public static synchronized void incTotal(int inc) {
        UmapProgress.PROGRESS.mTotal += inc;
        UmapProgress.update(0);
    }

    public static synchronized void finished() {
        UmapProgress.PROGRESS.mCounter = UmapProgress.PROGRESS.mTotal;
        UmapProgress.PROGRESS.mLastNotificationTime = 0L;
        UmapProgress.update(0);
    }

    public static void update() {
        UmapProgress.update(1);
    }

    public static synchronized void update(int n) {
        UmapProgress.PROGRESS.mCounter += n;
        if (UmapProgress.PROGRESS.mCounter > UmapProgress.PROGRESS.mTotal) {
            Utils.message("Update counter exceeded total: " + UmapProgress.PROGRESS.mCounter + " : " + UmapProgress.PROGRESS.mTotal);
        }
        PROGRESS.notifyListeners(UmapProgress.getProgress());
    }

    public static ProgressState getProgress() {
        return new ProgressState(UmapProgress.PROGRESS.mTotal, UmapProgress.PROGRESS.mCounter);
    }
}

