/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Arrays;
import java.util.Random;
import tagbio.umap.DefaultMatrix;
import tagbio.umap.Matrix;
import tagbio.umap.Sort;

final class MathUtils {
    private static final double INV_LOG2 = 1.0 / Math.log(2.0);

    private MathUtils() {
    }

    static double log2(double x) {
        return Math.log(x) * INV_LOG2;
    }

    static float max(float ... x) {
        float max = Float.NEGATIVE_INFINITY;
        for (float v : x) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    static float min(float ... x) {
        float min = Float.POSITIVE_INFINITY;
        for (float v : x) {
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    static float mean(float ... x) {
        float s = 0.0f;
        for (float v : x) {
            s += v;
        }
        return s / (float)x.length;
    }

    static float mean(float[][] x) {
        float s = 0.0f;
        long c = 0L;
        float[][] fArray = x;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] row;
            for (float v : row = fArray[i]) {
                s += v;
                ++c;
            }
        }
        return s / (float)c;
    }

    static float sum(float[][] x) {
        float s = 0.0f;
        float[][] fArray = x;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] row;
            for (float v : row = fArray[i]) {
                s += v;
            }
        }
        return s;
    }

    static double sum(double[][] x) {
        float s = 0.0f;
        double[][] dArray = x;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double v : row = dArray[i]) {
                s = (float)((double)s + v);
            }
        }
        return s;
    }

    static float[] filterPositive(float ... x) {
        int len = 0;
        for (float v : x) {
            if (!(v > 0.0f)) continue;
            ++len;
        }
        float[] res = new float[len];
        int k = 0;
        for (float v : x) {
            if (!(v > 0.0f)) continue;
            res[k++] = v;
        }
        return res;
    }

    static boolean containsNegative(int[][] x) {
        int[][] nArray = x;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] row;
            for (int v : row = nArray[i]) {
                if (v >= 0) continue;
                return true;
            }
        }
        return false;
    }

    static float[] multiply(float[] x, float s) {
        float[] res = new float[x.length];
        for (int k = 0; k < x.length; ++k) {
            res[k] = x[k] * s;
        }
        return res;
    }

    static float[] divide(float[] x, float s) {
        return MathUtils.multiply(x, 1.0f / s);
    }

    static float[] linspace(float start, float end, int n) {
        float[] res = new float[n];
        float span = end - start;
        float step = span / (float)(n - 1);
        for (int k = 0; k < res.length; ++k) {
            res[k] = start + (float)k * step;
        }
        return res;
    }

    static int[] identity(int n) {
        int[] id = new int[n];
        for (int k = 0; k < n; ++k) {
            id[k] = k;
        }
        return id;
    }

    static int[] argsort(float[] x) {
        int[] id = MathUtils.identity(x.length);
        Sort.sort(x, id);
        return id;
    }

    static void zeroEntriesBelowLimit(float[] x, float limit) {
        for (int k = 0; k < x.length; ++k) {
            if (!(x[k] < limit)) continue;
            x[k] = 0.0f;
        }
    }

    static float[][] subarray(float[][] x, int cols) {
        float[][] res = new float[x.length][];
        for (int k = 0; k < x.length; ++k) {
            res[k] = Arrays.copyOf(x[k], cols);
        }
        return res;
    }

    static int[][] subarray(int[][] x, int cols) {
        int[][] res = new int[x.length][];
        for (int k = 0; k < x.length; ++k) {
            res[k] = Arrays.copyOf(x[k], cols);
        }
        return res;
    }

    static Matrix promoteTranspose(float[] a) {
        float[][] res = new float[a.length][1];
        for (int k = 0; k < a.length; ++k) {
            res[k][0] = a[k];
        }
        return new DefaultMatrix(res);
    }

    static float[][] uniform(Random random, float lo, float hi, int n, int m) {
        float len = hi - lo;
        if (len <= 0.0f) {
            throw new IllegalArgumentException("lo must be smaller than hi");
        }
        float[][] res = new float[n][m];
        for (int k = 0; k < n; ++k) {
            for (int j = 0; j < m; ++j) {
                res[k][j] = lo + random.nextFloat() * len;
            }
        }
        return res;
    }

    static int[] subarray(int[] a, int lo, int hi) {
        int[] res = new int[hi - lo];
        System.arraycopy(a, lo, res, 0, res.length);
        return res;
    }

    static float[] subarray(float[] a, int lo, int hi) {
        float[] res = new float[hi - lo];
        System.arraycopy(a, lo, res, 0, res.length);
        return res;
    }
}

