/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Arrays;
import tagbio.umap.CooMatrix;
import tagbio.umap.MathUtils;
import tagbio.umap.Matrix;
import tagbio.umap.SparseVector;

class CsrMatrix
extends Matrix {
    private final int[] mIndptr;
    private final int[] mIndices;
    private final float[] mData;

    CsrMatrix(float[] data, int[] indptr, int[] indices, int rowCount, int colCount) {
        super(rowCount, colCount);
        this.mIndptr = indptr;
        this.mIndices = indices;
        this.mData = data;
    }

    @Override
    float get(int row, int col) {
        int colStart = this.mIndptr[row];
        int colEnd = this.mIndptr[row + 1];
        for (int p = colStart; p < colEnd; ++p) {
            if (this.mIndices[p] != col) continue;
            return this.mData[p];
        }
        return 0.0f;
    }

    @Override
    void set(int row, int col, float val) {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean isFinite() {
        for (float v : this.mData) {
            if (Float.isFinite(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    Matrix copy() {
        return new CsrMatrix(Arrays.copyOf(this.mData, this.mData.length), Arrays.copyOf(this.mIndptr, this.mIndptr.length), Arrays.copyOf(this.mIndices, this.mIndices.length), this.rows(), this.cols());
    }

    @Override
    CsrMatrix toCsr() {
        return this;
    }

    @Override
    Matrix add(Matrix m) {
        throw new UnsupportedOperationException();
    }

    @Override
    Matrix subtract(Matrix m) {
        throw new UnsupportedOperationException();
    }

    @Override
    Matrix multiply(Matrix m) {
        throw new UnsupportedOperationException();
    }

    @Override
    Matrix transpose() {
        throw new UnsupportedOperationException();
    }

    @Override
    Matrix multiply(float x) {
        float[] newData = Arrays.copyOf(this.mData, this.mData.length);
        int i = 0;
        while (i < newData.length) {
            int n = i++;
            newData[n] = newData[n] * x;
        }
        return new CsrMatrix(newData, this.mIndptr, this.mIndices, this.rows(), this.cols());
    }

    @Override
    Matrix rowNormalize() {
        float[] d = new float[this.mData.length];
        for (int row = 0; row < this.rows(); ++row) {
            int j;
            float max = this.mData[this.mIndptr[row]];
            for (j = this.mIndptr[row] + 1; j < this.mIndptr[row + 1]; ++j) {
                max = Math.max(max, this.mData[j]);
            }
            for (j = this.mIndptr[row]; j < this.mIndptr[row + 1]; ++j) {
                d[j] = this.mData[j] / max;
            }
        }
        return new CsrMatrix(d, this.mIndptr, this.mIndices, this.rows(), this.cols());
    }

    @Override
    Matrix l1Normalize() {
        float[] d = new float[this.mData.length];
        for (int row = 0; row < this.rows(); ++row) {
            int j;
            float l1 = 0.0f;
            for (j = this.mIndptr[row]; j < this.mIndptr[row + 1]; ++j) {
                l1 += Math.abs(this.mData[j]);
            }
            for (j = this.mIndptr[row]; j < this.mIndptr[row + 1]; ++j) {
                d[j] = this.mData[j] / l1;
            }
        }
        return new CsrMatrix(d, this.mIndptr, this.mIndices, this.rows(), this.cols());
    }

    int[][] reshapeIndicies(int rows, int cols) {
        int[][] res = new int[rows][cols];
        for (int row = 0; row < rows; ++row) {
            int end = this.mIndptr[row + 1];
            int col = 0;
            for (int pos = this.mIndptr[row]; col < cols && pos < end; ++col, ++pos) {
                res[row][col] = this.mIndices[pos];
            }
        }
        return res;
    }

    float[][] reshapeWeights(int rows, int cols) {
        float[][] res = new float[rows][cols];
        for (int row = 0; row < rows; ++row) {
            int end = this.mIndptr[row + 1];
            int col = 0;
            for (int pos = this.mIndptr[row]; col < cols && pos < end; ++col, ++pos) {
                res[row][col] = this.mData[pos];
            }
        }
        return res;
    }

    void intersect(CsrMatrix other, CooMatrix result, float mixWeight) {
        float leftMin = Math.max(MathUtils.min(this.mData) / 2.0f, 1.0E-8f);
        float rightMin = Math.max(MathUtils.min(other.mData) / 2.0f, 1.0E-8f);
        int[] row = result.row();
        int[] col = result.col();
        float[] data = result.data();
        for (int idx = 0; idx < row.length; ++idx) {
            int i = row[idx];
            int j = col[idx];
            float leftVal = leftMin;
            for (int k = this.mIndptr[i]; k < this.mIndptr[i + 1]; ++k) {
                if (this.mIndices[k] != j) continue;
                leftVal = this.mData[k];
            }
            float rightVal = rightMin;
            for (int k = other.mIndptr[i]; k < other.mIndptr[i + 1]; ++k) {
                if (other.mIndices[k] != j) continue;
                rightVal = other.mData[k];
            }
            if (!(leftVal > leftMin) && !(rightVal > rightMin)) continue;
            float f = (double)mixWeight < 0.5 ? (float)((double)leftVal * Math.pow(rightVal, (double)mixWeight / (1.0 - (double)mixWeight))) : (float)(Math.pow(leftVal, (1.0 - (double)mixWeight) / (double)mixWeight) * (double)rightVal);
            data[idx] = f;
        }
    }

    SparseVector vector(int row) {
        return new SparseVector(Arrays.copyOfRange(this.mIndices, this.mIndptr[row], this.mIndptr[row + 1]), Arrays.copyOfRange(this.mData, this.mIndptr[row], this.mIndptr[row + 1]));
    }
}

