/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap.metric;

import tagbio.umap.metric.Metric;

public class MahalanobisMetric
extends Metric {
    private final float[][] mV;

    public MahalanobisMetric(float[][] v) {
        super(false);
        this.mV = v;
    }

    @Override
    public float distance(float[] x, float[] y) {
        int i;
        float result = 0.0f;
        float[] diff = new float[x.length];
        for (i = 0; i < x.length; ++i) {
            diff[i] = x[i] - y[i];
        }
        for (i = 0; i < x.length; ++i) {
            double tmp = 0.0;
            for (int j = 0; j < x.length; ++j) {
                tmp += (double)(this.mV[i][j] * diff[j]);
            }
            result = (float)((double)result + tmp * (double)diff[i]);
        }
        return (float)Math.sqrt(result);
    }
}

