/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap.metric;

import tagbio.umap.metric.Metric;

public final class DiceMetric
extends Metric {
    public static final DiceMetric SINGLETON = new DiceMetric();

    private DiceMetric() {
        super(true);
    }

    @Override
    public float distance(float[] x, float[] y) {
        int numTrueTrue = 0;
        int numNotEqual = 0;
        for (int i = 0; i < x.length; ++i) {
            boolean xTrue = x[i] != 0.0f;
            boolean yTrue = y[i] != 0.0f;
            numTrueTrue += xTrue && yTrue ? 1 : 0;
            numNotEqual += xTrue != yTrue ? 1 : 0;
        }
        if (numNotEqual == 0) {
            return 0.0f;
        }
        return (float)numNotEqual / (float)(2 * numTrueTrue + numNotEqual);
    }
}

