/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.env;

import tech.kwik.agent15.env.AlgorithmMapping;

public class PlatformMapping {
    private static Platform currentPlatform;

    public static void usePlatformMapping(Platform platform) {
        if (currentPlatform == null) {
            currentPlatform = platform;
        } else if (platform != currentPlatform) {
            throw new IllegalArgumentException("Once set, platform cannot be changed");
        }
    }

    public static AlgorithmMapping algorithmMapping() {
        if (currentPlatform == Platform.Android) {
            return new AndroidMapping();
        }
        return new IdentityMapping();
    }

    public static enum Platform {
        JDK,
        Android;

    }

    private static class AndroidMapping
    implements AlgorithmMapping {
        private AndroidMapping() {
        }

        @Override
        public String get(String value) {
            if (value == null) {
                return null;
            }
            if (value.equals("RSASSA-PSS")) {
                return "SHA256withRSA/PSS";
            }
            return value;
        }

        @Override
        public String get(String signatureAlgorithm, int hashLength) {
            if (signatureAlgorithm == null) {
                return null;
            }
            if (signatureAlgorithm.equals("RSASSA-PSS")) {
                if (hashLength == 256) {
                    return "SHA256withRSA/PSS";
                }
                if (hashLength == 384) {
                    return "SHA384withRSA/PSS";
                }
                if (hashLength == 512) {
                    return "SHA512withRSA/PSS";
                }
                throw new IllegalArgumentException("Unsupported hash length: " + hashLength);
            }
            return signatureAlgorithm;
        }
    }

    private static class IdentityMapping
    implements AlgorithmMapping {
        private IdentityMapping() {
        }

        @Override
        public String get(String value) {
            return value;
        }

        @Override
        public String get(String signatureAlgorithm, int hashLength) {
            return signatureAlgorithm;
        }
    }
}

