/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.engine;

import java.io.IOException;
import java.nio.ByteBuffer;
import tech.kwik.agent15.ProtectionKeysType;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.TlsProtocolException;
import tech.kwik.agent15.engine.MessageProcessor;
import tech.kwik.agent15.extension.ExtensionParser;
import tech.kwik.agent15.handshake.CertificateMessage;
import tech.kwik.agent15.handshake.CertificateRequestMessage;
import tech.kwik.agent15.handshake.CertificateVerifyMessage;
import tech.kwik.agent15.handshake.ClientHello;
import tech.kwik.agent15.handshake.EncryptedExtensions;
import tech.kwik.agent15.handshake.FinishedMessage;
import tech.kwik.agent15.handshake.HandshakeMessage;
import tech.kwik.agent15.handshake.NewSessionTicketMessage;
import tech.kwik.agent15.handshake.ServerHello;

public class TlsMessageParser {
    private final ExtensionParser customExtensionParser;

    public TlsMessageParser() {
        this.customExtensionParser = null;
    }

    public TlsMessageParser(ExtensionParser customExtensionParser) {
        this.customExtensionParser = customExtensionParser;
    }

    public HandshakeMessage parseHandshakeMessage(ByteBuffer buffer) throws TlsProtocolException, IOException {
        return this.parseAndProcessHandshakeMessage(buffer, null, null);
    }

    public HandshakeMessage parseAndProcessHandshakeMessage(ByteBuffer buffer, MessageProcessor messageProcessor, ProtectionKeysType protectedBy) throws TlsProtocolException, IOException {
        HandshakeMessage parsedMessage;
        buffer.mark();
        byte messageType = buffer.get();
        int length = (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
        buffer.reset();
        if (messageType == TlsConstants.HandshakeType.client_hello.value) {
            ClientHello ch;
            parsedMessage = ch = new ClientHello(buffer, this.customExtensionParser);
            if (messageProcessor != null) {
                messageProcessor.received(ch, protectedBy);
            }
        } else if (messageType == TlsConstants.HandshakeType.server_hello.value) {
            ServerHello sh = new ServerHello().parse(buffer, length + 4);
            parsedMessage = sh;
            if (messageProcessor != null) {
                messageProcessor.received(sh, protectedBy);
            }
        } else if (messageType == TlsConstants.HandshakeType.encrypted_extensions.value) {
            EncryptedExtensions ee = new EncryptedExtensions().parse(buffer, length + 4, this.customExtensionParser);
            parsedMessage = ee;
            if (messageProcessor != null) {
                messageProcessor.received(ee, protectedBy);
            }
        } else if (messageType == TlsConstants.HandshakeType.certificate.value) {
            CertificateMessage cm = new CertificateMessage().parse(buffer);
            parsedMessage = cm;
            if (messageProcessor != null) {
                messageProcessor.received(cm, protectedBy);
            }
        } else if (messageType == TlsConstants.HandshakeType.certificate_request.value) {
            CertificateRequestMessage cr = new CertificateRequestMessage().parse(buffer);
            parsedMessage = cr;
            if (messageProcessor != null) {
                messageProcessor.received(cr, protectedBy);
            }
        } else if (messageType == TlsConstants.HandshakeType.certificate_verify.value) {
            CertificateVerifyMessage cv = new CertificateVerifyMessage().parse(buffer, length + 4);
            parsedMessage = cv;
            if (messageProcessor != null) {
                messageProcessor.received(cv, protectedBy);
            }
        } else if (messageType == TlsConstants.HandshakeType.finished.value) {
            FinishedMessage fm = new FinishedMessage().parse(buffer, length + 4);
            parsedMessage = fm;
            if (messageProcessor != null) {
                messageProcessor.received(fm, protectedBy);
            }
        } else if (messageType == TlsConstants.HandshakeType.new_session_ticket.value) {
            NewSessionTicketMessage nst = new NewSessionTicketMessage().parse(buffer);
            parsedMessage = nst;
            if (messageProcessor != null) {
                messageProcessor.received(nst, protectedBy);
            }
        } else {
            throw new TlsProtocolException("Invalid/unsupported message type (" + messageType + ")");
        }
        return parsedMessage;
    }
}

