/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.engine;

import java.io.IOException;
import tech.kwik.agent15.ProtectionKeysType;
import tech.kwik.agent15.TlsProtocolException;
import tech.kwik.agent15.handshake.CertificateMessage;
import tech.kwik.agent15.handshake.CertificateRequestMessage;
import tech.kwik.agent15.handshake.CertificateVerifyMessage;
import tech.kwik.agent15.handshake.ClientHello;
import tech.kwik.agent15.handshake.EncryptedExtensions;
import tech.kwik.agent15.handshake.FinishedMessage;
import tech.kwik.agent15.handshake.HandshakeMessage;
import tech.kwik.agent15.handshake.NewSessionTicketMessage;
import tech.kwik.agent15.handshake.ServerHello;

public interface MessageProcessor {
    default public void received(HandshakeMessage msg, ProtectionKeysType protectedBy) throws TlsProtocolException, IOException {
        if (msg instanceof ClientHello) {
            this.received((ClientHello)msg, protectedBy);
        } else if (msg instanceof ServerHello) {
            this.received((ServerHello)msg, protectedBy);
        } else if (msg instanceof EncryptedExtensions) {
            this.received((EncryptedExtensions)msg, protectedBy);
        } else if (msg instanceof CertificateMessage) {
            this.received((CertificateMessage)msg, protectedBy);
        } else if (msg instanceof CertificateVerifyMessage) {
            this.received((CertificateVerifyMessage)msg, protectedBy);
        } else if (msg instanceof FinishedMessage) {
            this.received((FinishedMessage)msg, protectedBy);
        } else if (msg instanceof NewSessionTicketMessage) {
            this.received((NewSessionTicketMessage)msg, protectedBy);
        } else if (msg instanceof CertificateRequestMessage) {
            this.received((CertificateRequestMessage)msg, protectedBy);
        } else {
            throw new TlsProtocolException("Unexpected message type: " + msg.getClass().getSimpleName());
        }
    }

    public void received(ClientHello var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;

    public void received(ServerHello var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;

    public void received(EncryptedExtensions var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;

    public void received(CertificateMessage var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;

    public void received(CertificateVerifyMessage var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;

    public void received(FinishedMessage var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;

    public void received(NewSessionTicketMessage var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;

    public void received(CertificateRequestMessage var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;
}

