/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.engine.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import tech.kwik.agent15.NewSessionTicket;
import tech.kwik.agent15.ProtectionKeysType;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.TlsProtocolException;
import tech.kwik.agent15.alert.BadCertificateAlert;
import tech.kwik.agent15.alert.CertificateUnknownAlert;
import tech.kwik.agent15.alert.DecryptErrorAlert;
import tech.kwik.agent15.alert.ErrorAlert;
import tech.kwik.agent15.alert.HandshakeFailureAlert;
import tech.kwik.agent15.alert.IllegalParameterAlert;
import tech.kwik.agent15.alert.MissingExtensionAlert;
import tech.kwik.agent15.alert.UnexpectedMessageAlert;
import tech.kwik.agent15.alert.UnsupportedExtensionAlert;
import tech.kwik.agent15.engine.CertificateWithPrivateKey;
import tech.kwik.agent15.engine.ClientMessageProcessor;
import tech.kwik.agent15.engine.ClientMessageSender;
import tech.kwik.agent15.engine.DefaultHostnameVerifier;
import tech.kwik.agent15.engine.HostnameVerifier;
import tech.kwik.agent15.engine.TlsClientEngine;
import tech.kwik.agent15.engine.TlsStatusEventHandler;
import tech.kwik.agent15.engine.impl.TlsEngineImpl;
import tech.kwik.agent15.engine.impl.TlsState;
import tech.kwik.agent15.engine.impl.TranscriptHash;
import tech.kwik.agent15.extension.CertificateAuthoritiesExtension;
import tech.kwik.agent15.extension.ClientHelloPreSharedKeyExtension;
import tech.kwik.agent15.extension.Extension;
import tech.kwik.agent15.extension.KeyShareExtension;
import tech.kwik.agent15.extension.PreSharedKeyExtension;
import tech.kwik.agent15.extension.ServerPreSharedKeyExtension;
import tech.kwik.agent15.extension.SignatureAlgorithmsExtension;
import tech.kwik.agent15.extension.SupportedVersionsExtension;
import tech.kwik.agent15.extension.UnknownExtension;
import tech.kwik.agent15.handshake.CertificateMessage;
import tech.kwik.agent15.handshake.CertificateRequestMessage;
import tech.kwik.agent15.handshake.CertificateVerifyMessage;
import tech.kwik.agent15.handshake.ClientHello;
import tech.kwik.agent15.handshake.EncryptedExtensions;
import tech.kwik.agent15.handshake.FinishedMessage;
import tech.kwik.agent15.handshake.NewSessionTicketMessage;
import tech.kwik.agent15.handshake.ServerHello;
import tech.kwik.agent15.log.Logger;

public class TlsClientEngineImpl
extends TlsEngineImpl
implements TlsClientEngine,
ClientMessageProcessor {
    public static final List<TlsConstants.SignatureScheme> AVAILABLE_SIGNATURES = List.of(TlsConstants.SignatureScheme.rsa_pss_rsae_sha256, TlsConstants.SignatureScheme.rsa_pss_rsae_sha384, TlsConstants.SignatureScheme.rsa_pss_rsae_sha512, TlsConstants.SignatureScheme.ecdsa_secp256r1_sha256, TlsConstants.SignatureScheme.ecdsa_secp384r1_sha384, TlsConstants.SignatureScheme.ecdsa_secp521r1_sha512);
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private final ClientMessageSender sender;
    private final TlsStatusEventHandler statusHandler;
    private String serverName;
    private boolean compatibilityMode;
    private List<TlsConstants.CipherSuite> supportedCiphers;
    private TlsConstants.NamedGroup ecCurve;
    private TlsConstants.CipherSuite selectedCipher;
    private List<Extension> requestedExtensions;
    private List<Extension> sentExtensions;
    private Status status = Status.Start;
    private ClientHello clientHello;
    private TranscriptHash transcriptHash;
    private List<TlsConstants.SignatureScheme> supportedSignatures;
    private X509Certificate serverCertificate;
    private List<X509Certificate> serverCertificateChain = Collections.emptyList();
    private X509TrustManager customTrustManager;
    private NewSessionTicket newSessionTicket;
    private HostnameVerifier hostnameVerifier;
    private List<NewSessionTicket> obtainedNewSessionTickets;
    private boolean pskAccepted = false;
    private boolean clientAuthRequested;
    private List<X500Principal> clientCertificateAuthorities;
    private Function<List<X500Principal>, CertificateWithPrivateKey> clientCertificateSelector;
    private List<TlsConstants.SignatureScheme> serverSupportedSignatureSchemes;

    public TlsClientEngineImpl(ClientMessageSender clientMessageSender, TlsStatusEventHandler tlsStatusHandler) {
        this.sender = clientMessageSender;
        this.statusHandler = tlsStatusHandler;
        this.supportedCiphers = new ArrayList<TlsConstants.CipherSuite>();
        this.requestedExtensions = new ArrayList<Extension>();
        this.hostnameVerifier = new DefaultHostnameVerifier();
        this.obtainedNewSessionTickets = new ArrayList<NewSessionTicket>();
        this.clientCertificateSelector = l -> null;
    }

    @Override
    public void startHandshake() throws IOException {
        this.startHandshake(TlsConstants.NamedGroup.secp256r1, List.of(TlsConstants.SignatureScheme.rsa_pss_rsae_sha256, TlsConstants.SignatureScheme.ecdsa_secp256r1_sha256));
    }

    @Override
    public void startHandshake(TlsConstants.NamedGroup ecCurve) throws IOException {
        this.startHandshake(ecCurve, List.of(TlsConstants.SignatureScheme.rsa_pss_rsae_sha256));
    }

    @Override
    public void startHandshake(TlsConstants.NamedGroup ecCurve, List<TlsConstants.SignatureScheme> signatureSchemes) throws IOException {
        List<Extension> extensions;
        if (this.status != Status.Start) {
            throw new IllegalStateException("Handshake already started");
        }
        if (!KeyShareExtension.supportedCurves.contains((Object)ecCurve)) {
            throw new IllegalArgumentException("Named group " + String.valueOf((Object)ecCurve) + " not supported");
        }
        if (signatureSchemes.stream().anyMatch(scheme -> !AVAILABLE_SIGNATURES.contains(scheme))) {
            ArrayList<TlsConstants.SignatureScheme> unsupportedSignatures = new ArrayList<TlsConstants.SignatureScheme>(signatureSchemes);
            unsupportedSignatures.removeAll(AVAILABLE_SIGNATURES);
            throw new IllegalArgumentException("Unsupported signature scheme(s): " + String.valueOf(unsupportedSignatures));
        }
        if (this.newSessionTicket != null && !this.supportedCiphers.contains((Object)this.newSessionTicket.getCipher())) {
            throw new IllegalStateException("For session resumption, support ciphers should contain the cipher used with the session-to-resume (" + this.newSessionTicket.getCipher().toString() + ")");
        }
        this.supportedSignatures = signatureSchemes;
        this.ecCurve = ecCurve;
        this.generateKeys(ecCurve);
        if (this.serverName == null || this.supportedCiphers.isEmpty()) {
            throw new IllegalStateException("not all mandatory properties are set");
        }
        if (this.newSessionTicket != null) {
            extensions = new ArrayList<Extension>();
            extensions.addAll(this.requestedExtensions);
            extensions.add(new ClientHelloPreSharedKeyExtension(this.newSessionTicket));
            TlsConstants.CipherSuite cipher = this.newSessionTicket.getCipher();
            this.transcriptHash = new TranscriptHash(TlsClientEngineImpl.hashLength(cipher));
            this.state = new TlsState(this.transcriptHash, this.newSessionTicket.getPSK(), TlsClientEngineImpl.keyLength(cipher), TlsClientEngineImpl.hashLength(cipher));
        } else {
            extensions = this.requestedExtensions;
        }
        this.clientHello = new ClientHello(this.serverName, this.publicKey, this.compatibilityMode, this.supportedCiphers, this.supportedSignatures, ecCurve, extensions, this.state, ClientHello.PskKeyEstablishmentMode.PSKwithDHE);
        this.sentExtensions = this.clientHello.getExtensions();
        if (this.state != null) {
            this.transcriptHash.record(this.clientHello);
            this.state.computeEarlyTrafficSecret();
            this.statusHandler.earlySecretsKnown();
        }
        this.sender.send(this.clientHello);
        this.status = Status.WaitServerHello;
    }

    @Override
    public void received(ServerHello serverHello, ProtectionKeysType protectedBy) throws MissingExtensionAlert, IllegalParameterAlert {
        if (this.status != Status.WaitServerHello) {
            return;
        }
        boolean containsSupportedVersionExt = serverHello.getExtensions().stream().anyMatch(ext -> ext instanceof SupportedVersionsExtension);
        boolean containsKeyExt = serverHello.getExtensions().stream().anyMatch(ext -> ext instanceof PreSharedKeyExtension || ext instanceof KeyShareExtension);
        if (!containsSupportedVersionExt || !containsKeyExt) {
            throw new MissingExtensionAlert();
        }
        short tlsVersion = serverHello.getExtensions().stream().filter(extension -> extension instanceof SupportedVersionsExtension).map(extension -> ((SupportedVersionsExtension)extension).getTlsVersion()).findFirst().get();
        if (tlsVersion != 772) {
            throw new IllegalParameterAlert("invalid tls version");
        }
        if (serverHello.getExtensions().stream().filter(this::recognizedExtension).anyMatch(ext -> !(ext instanceof SupportedVersionsExtension) && !(ext instanceof PreSharedKeyExtension) && !(ext instanceof KeyShareExtension))) {
            throw new IllegalParameterAlert("illegal extension in server hello");
        }
        Optional<Extension> keyShareExtension = serverHello.getExtensions().stream().filter(extension -> extension instanceof KeyShareExtension).findFirst();
        Optional<Object> keyShare = Optional.empty();
        if (keyShareExtension.isPresent() && ((KeyShareExtension.KeyShareEntry)(keyShare = Optional.of(keyShareExtension.filter(extension -> !((KeyShareExtension)extension).getKeyShareEntries().isEmpty()).map(extension -> ((KeyShareExtension)extension).getKeyShareEntries().get(0)).orElseThrow(() -> new IllegalParameterAlert("")))).get()).getNamedGroup() != this.ecCurve) {
            throw new IllegalParameterAlert("server supplied key share does not match client supported named group");
        }
        Optional<Extension> preSharedKey = serverHello.getExtensions().stream().filter(extension -> extension instanceof ServerPreSharedKeyExtension).findFirst();
        if (keyShare.isEmpty() && preSharedKey.isEmpty()) {
            throw new MissingExtensionAlert(" either the pre_shared_key extension or the key_share extension must be present");
        }
        if (preSharedKey.isPresent()) {
            this.pskAccepted = true;
        }
        if (!this.supportedCiphers.contains((Object)serverHello.getCipherSuite())) {
            throw new IllegalParameterAlert("cipher suite does not match");
        }
        this.selectedCipher = serverHello.getCipherSuite();
        if (this.state == null) {
            this.transcriptHash = new TranscriptHash(TlsClientEngineImpl.hashLength(this.selectedCipher));
            this.state = new TlsState(this.transcriptHash, TlsClientEngineImpl.keyLength(this.selectedCipher), TlsClientEngineImpl.hashLength(this.selectedCipher));
            this.transcriptHash.record(this.clientHello);
            this.state.computeEarlyTrafficSecret();
            this.statusHandler.earlySecretsKnown();
        }
        if (preSharedKey.isPresent()) {
            this.state.setPskSelected(((ServerPreSharedKeyExtension)preSharedKey.get()).getSelectedIdentity());
            Logger.debug("Server has accepted PSK key establishment");
        } else {
            this.state.setNoPskSelected();
        }
        if (keyShare.isPresent()) {
            this.state.setOwnKey(this.privateKey);
            this.state.setPeerKey(((KeyShareExtension.KeyShareEntry)keyShare.get()).getKey());
            this.state.computeSharedSecret();
        }
        this.transcriptHash.record(serverHello);
        this.state.computeHandshakeSecrets();
        this.status = Status.WaitEncryptedExtensions;
        this.statusHandler.handshakeSecretsKnown();
    }

    @Override
    public void received(EncryptedExtensions encryptedExtensions, ProtectionKeysType protectedBy) throws TlsProtocolException {
        if (protectedBy != ProtectionKeysType.Handshake) {
            throw new UnexpectedMessageAlert("incorrect protection level");
        }
        if (this.status != Status.WaitEncryptedExtensions) {
            throw new UnexpectedMessageAlert("unexpected encrypted extensions message");
        }
        List clientExtensionTypes = this.sentExtensions.stream().map(extension -> extension.getClass()).collect(Collectors.toList());
        boolean allClientResponses = encryptedExtensions.getExtensions().stream().filter(ext -> !(ext instanceof UnknownExtension)).allMatch(ext -> clientExtensionTypes.contains(ext.getClass()));
        if (!allClientResponses) {
            throw new UnsupportedExtensionAlert("extension response to missing request");
        }
        int uniqueExtensions = encryptedExtensions.getExtensions().stream().map(extension -> extension.getClass()).collect(Collectors.toSet()).size();
        if (uniqueExtensions != encryptedExtensions.getExtensions().size()) {
            throw new UnsupportedExtensionAlert("duplicate extensions not allowed");
        }
        this.transcriptHash.record(encryptedExtensions);
        this.status = this.pskAccepted ? Status.WaitFinished : Status.WaitCertificateRequest;
        this.statusHandler.extensionsReceived(encryptedExtensions.getExtensions());
    }

    @Override
    public void received(CertificateMessage certificateMessage, ProtectionKeysType protectedBy) throws TlsProtocolException {
        if (protectedBy != ProtectionKeysType.Handshake) {
            throw new UnexpectedMessageAlert("incorrect protection level");
        }
        if (this.status != Status.WaitCertificate && this.status != Status.WaitCertificateRequest) {
            throw new UnexpectedMessageAlert("unexpected certificate message");
        }
        if (certificateMessage.getRequestContext().length > 0) {
            throw new IllegalParameterAlert("certificate request context should be zero length");
        }
        if (certificateMessage.getEndEntityCertificate() == null) {
            throw new IllegalParameterAlert("missing certificate");
        }
        this.serverCertificate = certificateMessage.getEndEntityCertificate();
        this.serverCertificateChain = certificateMessage.getCertificateChain();
        this.transcriptHash.recordServer(certificateMessage);
        this.status = Status.WaitCertificateVerify;
    }

    @Override
    public void received(CertificateVerifyMessage certificateVerifyMessage, ProtectionKeysType protectedBy) throws TlsProtocolException {
        if (protectedBy != ProtectionKeysType.Handshake) {
            throw new UnexpectedMessageAlert("incorrect protection level");
        }
        if (this.status != Status.WaitCertificateVerify) {
            throw new UnexpectedMessageAlert("unexpected certificate verify message");
        }
        TlsConstants.SignatureScheme signatureScheme = certificateVerifyMessage.getSignatureScheme();
        if (signatureScheme == null || !this.supportedSignatures.contains((Object)signatureScheme)) {
            throw new IllegalParameterAlert("signature scheme does not match");
        }
        byte[] signature = certificateVerifyMessage.getSignature();
        if (!this.verifySignature(signature, signatureScheme, this.serverCertificate, this.transcriptHash.getServerHash(TlsConstants.HandshakeType.certificate))) {
            throw new DecryptErrorAlert("signature verification fails");
        }
        this.checkCertificateValidity(this.serverCertificateChain);
        if (!this.hostnameVerifier.verify(this.serverName, this.serverCertificate)) {
            throw new CertificateUnknownAlert("servername does not match");
        }
        this.transcriptHash.recordServer(certificateVerifyMessage);
        this.status = Status.WaitFinished;
    }

    @Override
    public void received(FinishedMessage finishedMessage, ProtectionKeysType protectedBy) throws ErrorAlert, IOException {
        if (protectedBy != ProtectionKeysType.Handshake) {
            throw new UnexpectedMessageAlert("incorrect protection level");
        }
        if (this.status != Status.WaitFinished) {
            throw new UnexpectedMessageAlert("unexpected finished message");
        }
        this.transcriptHash.recordServer(finishedMessage);
        byte[] serverHmac = this.computeFinishedVerifyData(this.transcriptHash.getServerHash(TlsConstants.HandshakeType.certificate_verify), this.state.getServerHandshakeTrafficSecret());
        if (!Arrays.equals(finishedMessage.getVerifyData(), serverHmac)) {
            throw new DecryptErrorAlert("incorrect finished message");
        }
        if (this.clientAuthRequested) {
            this.sendClientAuth();
        }
        byte[] clientHmac = this.computeFinishedVerifyData(this.transcriptHash.getClientHash(TlsConstants.HandshakeType.certificate_verify), this.state.getClientHandshakeTrafficSecret());
        FinishedMessage clientFinished = new FinishedMessage(clientHmac);
        this.sender.send(clientFinished);
        this.transcriptHash.recordClient(clientFinished);
        this.state.computeApplicationSecrets();
        this.state.computeResumptionMasterSecret();
        this.status = Status.Connected;
        this.statusHandler.handshakeFinished();
    }

    @Override
    public void received(NewSessionTicketMessage nst, ProtectionKeysType protectedBy) throws UnexpectedMessageAlert {
        if (protectedBy != ProtectionKeysType.Application) {
            throw new UnexpectedMessageAlert("incorrect protection level");
        }
        NewSessionTicket ticket = new NewSessionTicket(this.state.computePSK(nst.getTicketNonce()), nst, this.selectedCipher);
        this.obtainedNewSessionTickets.add(ticket);
        this.statusHandler.newSessionTicketReceived(ticket);
    }

    @Override
    public void received(CertificateRequestMessage certificateRequestMessage, ProtectionKeysType protectedBy) throws TlsProtocolException, IOException {
        if (protectedBy != ProtectionKeysType.Handshake) {
            throw new UnexpectedMessageAlert("incorrect protection level");
        }
        if (this.status != Status.WaitCertificateRequest) {
            throw new UnexpectedMessageAlert("unexpected certificate request message");
        }
        this.serverSupportedSignatureSchemes = certificateRequestMessage.getExtensions().stream().filter(extension -> extension instanceof SignatureAlgorithmsExtension).findFirst().map(extension -> ((SignatureAlgorithmsExtension)extension).getSignatureAlgorithms()).orElseThrow(() -> new MissingExtensionAlert());
        this.transcriptHash.record(certificateRequestMessage);
        this.clientCertificateAuthorities = certificateRequestMessage.getExtensions().stream().filter(extension -> extension instanceof CertificateAuthoritiesExtension).findFirst().map(extension -> ((CertificateAuthoritiesExtension)extension).getAuthorities()).orElse(Collections.emptyList());
        this.clientAuthRequested = true;
        this.status = Status.WaitCertificate;
    }

    protected boolean verifySignature(byte[] signatureToVerify, TlsConstants.SignatureScheme signatureScheme, Certificate certificate, byte[] transcriptHash) throws HandshakeFailureAlert {
        ByteBuffer contentToSign = ByteBuffer.allocate(64 + "TLS 1.3, server CertificateVerify".getBytes(ISO_8859_1).length + 1 + transcriptHash.length);
        for (int i = 0; i < 64; ++i) {
            contentToSign.put((byte)32);
        }
        contentToSign.put("TLS 1.3, server CertificateVerify".getBytes(ISO_8859_1));
        contentToSign.put((byte)0);
        contentToSign.put(transcriptHash);
        boolean verified = false;
        try {
            Signature signatureAlgorithm = this.getSignatureAlgorithm(signatureScheme);
            signatureAlgorithm.initVerify(certificate);
            signatureAlgorithm.update(contentToSign.array());
            verified = signatureAlgorithm.verify(signatureToVerify);
        }
        catch (InvalidKeyException e) {
            Logger.debug("Certificate verify: invalid key.");
        }
        catch (SignatureException e) {
            Logger.debug("Certificate verify: invalid signature.");
        }
        return verified;
    }

    protected void checkCertificateValidity(List<X509Certificate> certificates) throws BadCertificateAlert {
        try {
            if (this.customTrustManager != null) {
                this.customTrustManager.checkServerTrusted(certificates.toArray(new X509Certificate[certificates.size()]), "RSA");
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                trustManagerFactory.init((KeyStore)null);
                X509TrustManager trustMgr = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
                trustMgr.checkServerTrusted(certificates.toArray(new X509Certificate[certificates.size()]), "UNKNOWN");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unsupported trust manager algorithm");
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("keystore exception");
        }
        catch (CertificateException e) {
            throw new BadCertificateAlert(this.extractReason(e).orElse("certificate validation failed"));
        }
    }

    private void sendClientAuth() throws IOException, ErrorAlert {
        CertificateWithPrivateKey certificateWithKey = this.clientCertificateSelector.apply(this.clientCertificateAuthorities);
        CertificateMessage certificateMessage = new CertificateMessage(certificateWithKey != null ? certificateWithKey.getCertificate() : null);
        this.sender.send(certificateMessage);
        this.transcriptHash.recordClient(certificateMessage);
        if (certificateWithKey != null) {
            TlsConstants.SignatureScheme selectedSignatureScheme = this.serverSupportedSignatureSchemes.stream().filter(this.supportedSignatures::contains).filter(scheme -> this.certificateSupportsSignature(certificateWithKey.getCertificate(), (TlsConstants.SignatureScheme)((Object)scheme))).findFirst().orElseThrow(() -> new HandshakeFailureAlert("failed to negotiate signature scheme"));
            PrivateKey privateKey = certificateWithKey.getPrivateKey();
            byte[] hash = this.transcriptHash.getClientHash(TlsConstants.HandshakeType.certificate);
            byte[] signature = this.computeSignature(hash, privateKey, selectedSignatureScheme, true);
            CertificateVerifyMessage certificateVerify = new CertificateVerifyMessage(selectedSignatureScheme, signature);
            this.sender.send(certificateVerify);
            this.transcriptHash.recordClient(certificateVerify);
        }
    }

    private boolean certificateSupportsSignature(X509Certificate cert, TlsConstants.SignatureScheme signatureScheme) {
        String certSignAlg = cert.getSigAlgName();
        if (certSignAlg.toLowerCase().contains("withrsa")) {
            return List.of(TlsConstants.SignatureScheme.rsa_pss_rsae_sha256, TlsConstants.SignatureScheme.rsa_pss_rsae_sha384).contains((Object)signatureScheme);
        }
        if (certSignAlg.toLowerCase().contains("withecdsa")) {
            return List.of(TlsConstants.SignatureScheme.ecdsa_secp256r1_sha256).contains((Object)signatureScheme);
        }
        return false;
    }

    private Optional<String> extractReason(CertificateException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof CertPathValidatorException) {
            return Optional.of(cause.getMessage() + ": " + String.valueOf(((CertPathValidatorException)cause).getReason()));
        }
        if (cause instanceof CertPathBuilderException) {
            return Optional.of(cause.getMessage());
        }
        return Optional.empty();
    }

    @Override
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    @Override
    public void addSupportedCiphers(List<TlsConstants.CipherSuite> supportedCiphers) {
        this.supportedCiphers.addAll(supportedCiphers);
    }

    @Override
    public void addExtensions(List<Extension> extensions) {
        this.requestedExtensions.addAll(extensions);
    }

    @Override
    public void add(Extension extension) {
        this.requestedExtensions.add(extension);
    }

    @Override
    public void setTrustManager(X509TrustManager customTrustManager) {
        this.customTrustManager = customTrustManager;
    }

    @Override
    public void setNewSessionTicket(NewSessionTicket newSessionTicket) {
        this.newSessionTicket = newSessionTicket;
    }

    @Override
    public TlsConstants.CipherSuite getSelectedCipher() {
        if (this.selectedCipher != null) {
            return this.selectedCipher;
        }
        throw new IllegalStateException("No (valid) server hello received yet");
    }

    @Override
    public List<NewSessionTicket> getNewSessionTickets() {
        return this.obtainedNewSessionTickets;
    }

    @Override
    public List<X509Certificate> getServerCertificateChain() {
        return this.serverCertificateChain;
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier != null) {
            this.hostnameVerifier = hostnameVerifier;
        }
    }

    @Override
    public boolean handshakeFinished() {
        return this.status == Status.Connected;
    }

    @Override
    public void setClientCertificateCallback(Function<List<X500Principal>, CertificateWithPrivateKey> callback) {
        this.clientCertificateSelector = callback;
    }

    static enum Status {
        Start,
        WaitServerHello,
        WaitEncryptedExtensions,
        WaitCertificateRequest,
        WaitCertificate,
        WaitCertificateVerify,
        WaitFinished,
        Connected;

    }
}

