/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.engine;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.luminis.tls.ProtectionKeysType;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.engine.MessageProcessor;
import net.luminis.tls.extension.ExtensionParser;
import net.luminis.tls.handshake.CertificateMessage;
import net.luminis.tls.handshake.CertificateRequestMessage;
import net.luminis.tls.handshake.CertificateVerifyMessage;
import net.luminis.tls.handshake.ClientHello;
import net.luminis.tls.handshake.EncryptedExtensions;
import net.luminis.tls.handshake.FinishedMessage;
import net.luminis.tls.handshake.HandshakeMessage;
import net.luminis.tls.handshake.NewSessionTicketMessage;
import net.luminis.tls.handshake.ServerHello;

public class TlsMessageParser {
    private final ExtensionParser customExtensionParser;

    public TlsMessageParser() {
        this.customExtensionParser = null;
    }

    public TlsMessageParser(ExtensionParser customExtensionParser) {
        this.customExtensionParser = customExtensionParser;
    }

    public HandshakeMessage parseAndProcessHandshakeMessage(ByteBuffer buffer, MessageProcessor messageProcessor, ProtectionKeysType protectedBy) throws TlsProtocolException, IOException {
        HandshakeMessage parsedMessage;
        buffer.mark();
        byte messageType = buffer.get();
        int length = (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
        buffer.reset();
        if (messageType == TlsConstants.HandshakeType.client_hello.value) {
            ClientHello ch;
            parsedMessage = ch = new ClientHello(buffer, this.customExtensionParser);
            messageProcessor.received(ch, protectedBy);
        } else if (messageType == TlsConstants.HandshakeType.server_hello.value) {
            ServerHello sh = new ServerHello().parse(buffer, length + 4);
            parsedMessage = sh;
            messageProcessor.received(sh, protectedBy);
        } else if (messageType == TlsConstants.HandshakeType.encrypted_extensions.value) {
            EncryptedExtensions ee = new EncryptedExtensions().parse(buffer, length + 4, this.customExtensionParser);
            parsedMessage = ee;
            messageProcessor.received(ee, protectedBy);
        } else if (messageType == TlsConstants.HandshakeType.certificate.value) {
            CertificateMessage cm = new CertificateMessage().parse(buffer);
            parsedMessage = cm;
            messageProcessor.received(cm, protectedBy);
        } else if (messageType == TlsConstants.HandshakeType.certificate_request.value) {
            CertificateRequestMessage cr = new CertificateRequestMessage().parse(buffer);
            parsedMessage = cr;
            messageProcessor.received(cr, protectedBy);
        } else if (messageType == TlsConstants.HandshakeType.certificate_verify.value) {
            CertificateVerifyMessage cv = new CertificateVerifyMessage().parse(buffer, length + 4);
            parsedMessage = cv;
            messageProcessor.received(cv, protectedBy);
        } else if (messageType == TlsConstants.HandshakeType.finished.value) {
            FinishedMessage fm = new FinishedMessage().parse(buffer, length + 4);
            parsedMessage = fm;
            messageProcessor.received(fm, protectedBy);
        } else if (messageType == TlsConstants.HandshakeType.new_session_ticket.value) {
            NewSessionTicketMessage nst = new NewSessionTicketMessage().parse(buffer);
            parsedMessage = nst;
            messageProcessor.received(nst, protectedBy);
        } else {
            throw new TlsProtocolException("Invalid/unsupported message type (" + messageType + ")");
        }
        return parsedMessage;
    }
}

