/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.pluginutils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.pluginutils.FileUtils;

public class BaseFileCache {
    private final FileUtils fileUtils;
    private final Path cacheDir;

    public BaseFileCache(FileUtils fileUtils, Path cacheDir) throws IOException {
        this.fileUtils = fileUtils;
        this.cacheDir = cacheDir;
        Files.createDirectories(this.cacheDir, new FileAttribute[0]);
    }

    protected Optional<String> getFileContent(String key) {
        return this.readFileContent(this.getAbsoluteFile(key));
    }

    protected void putFileContent(String key, String content) {
        this.writeFileContent(this.getAbsoluteFile(key), content);
    }

    private void writeFileContent(Path file, String content) {
        this.fileUtils.writeFileContent(file, content, StandardOpenOption.CREATE_NEW);
    }

    private Optional<String> readFileContent(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(this.fileUtils.readFileContent(file));
    }

    private Path getAbsoluteFile(String key) {
        Path file = this.cacheDir.resolve(this.convertKeyToFileName(key));
        if (!file.startsWith(this.cacheDir)) {
            throw new RuntimeException(String.format("File \"%s\" is outside of cache dir \"%s\"", StringEscapeUtils.escapeString((String)file.toString()), StringEscapeUtils.escapeString((String)this.cacheDir.toString())));
        }
        return file;
    }

    private String convertKeyToFileName(String key) {
        try {
            return URLEncoder.encode(key, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

