/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.pluginapi.finders.models;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import tech.kronicle.pluginapi.finders.models.GenericTag;
import tech.kronicle.sdk.utils.ListUtils;

public final class GenericSpan {
    private final String id;
    private final String parentId;
    private final String sourceName;
    private final String name;
    private final List<GenericTag> subComponentTags;
    private final Long timestamp;
    private final Long duration;

    public GenericSpan(String id, String parentId, String sourceName, String name, List<GenericTag> subComponentTags, Long timestamp, Long duration) {
        this.id = id;
        this.parentId = parentId;
        this.sourceName = sourceName;
        this.name = name;
        this.subComponentTags = this.createUnmodifiableListSortedByTagKey(subComponentTags);
        this.timestamp = timestamp;
        this.duration = duration;
    }

    private List<GenericTag> createUnmodifiableListSortedByTagKey(List<GenericTag> list) {
        if (Objects.isNull(list)) {
            return List.of();
        }
        return ListUtils.createUnmodifiableList(list.stream().sorted(Comparator.comparing(GenericTag::getKey)).collect(Collectors.toList()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static GenericSpanBuilder builder() {
        return new GenericSpanBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSourceName() {
        return this.sourceName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<GenericTag> getSubComponentTags() {
        return this.subComponentTags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericSpan)) {
            return false;
        }
        GenericSpan other = (GenericSpan)o;
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<GenericTag> this$subComponentTags = this.getSubComponentTags();
        List<GenericTag> other$subComponentTags = other.getSubComponentTags();
        return !(this$subComponentTags == null ? other$subComponentTags != null : !((Object)this$subComponentTags).equals(other$subComponentTags));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<GenericTag> $subComponentTags = this.getSubComponentTags();
        result = result * 59 + ($subComponentTags == null ? 43 : ((Object)$subComponentTags).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "GenericSpan(id=" + this.getId() + ", parentId=" + this.getParentId() + ", sourceName=" + this.getSourceName() + ", name=" + this.getName() + ", subComponentTags=" + this.getSubComponentTags() + ", timestamp=" + this.getTimestamp() + ", duration=" + this.getDuration() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GenericSpan withId(String id) {
        return this.id == id ? this : new GenericSpan(id, this.parentId, this.sourceName, this.name, this.subComponentTags, this.timestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GenericSpan withParentId(String parentId) {
        return this.parentId == parentId ? this : new GenericSpan(this.id, parentId, this.sourceName, this.name, this.subComponentTags, this.timestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GenericSpan withSourceName(String sourceName) {
        return this.sourceName == sourceName ? this : new GenericSpan(this.id, this.parentId, sourceName, this.name, this.subComponentTags, this.timestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GenericSpan withName(String name) {
        return this.name == name ? this : new GenericSpan(this.id, this.parentId, this.sourceName, name, this.subComponentTags, this.timestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GenericSpan withSubComponentTags(List<GenericTag> subComponentTags) {
        return this.subComponentTags == subComponentTags ? this : new GenericSpan(this.id, this.parentId, this.sourceName, this.name, subComponentTags, this.timestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GenericSpan withTimestamp(Long timestamp) {
        return this.timestamp == timestamp ? this : new GenericSpan(this.id, this.parentId, this.sourceName, this.name, this.subComponentTags, timestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GenericSpan withDuration(Long duration) {
        return this.duration == duration ? this : new GenericSpan(this.id, this.parentId, this.sourceName, this.name, this.subComponentTags, this.timestamp, duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class GenericSpanBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String parentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String sourceName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<GenericTag> subComponentTags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Long timestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Long duration;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        GenericSpanBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericSpanBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericSpanBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericSpanBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericSpanBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericSpanBuilder subComponentTags(List<GenericTag> subComponentTags) {
            this.subComponentTags = subComponentTags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericSpanBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericSpanBuilder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericSpan build() {
            return new GenericSpan(this.id, this.parentId, this.sourceName, this.name, this.subComponentTags, this.timestamp, this.duration);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GenericSpan.GenericSpanBuilder(id=" + this.id + ", parentId=" + this.parentId + ", sourceName=" + this.sourceName + ", name=" + this.name + ", subComponentTags=" + this.subComponentTags + ", timestamp=" + this.timestamp + ", duration=" + this.duration + ")";
        }
    }
}

