/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.services;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.gradlestaticanalyzer.internal.models.mavenxml.Metadata;
import tech.kronicle.gradlestaticanalyzer.internal.models.mavenxml.metadata.Versioning;
import tech.kronicle.gradlestaticanalyzer.internal.models.mavenxml.metadata.Versions;
import tech.kronicle.gradlestaticanalyzer.internal.services.MavenRepositoryFileDownloader;
import tech.kronicle.gradlestaticanalyzer.internal.utils.ArtifactUtils;
import tech.kronicle.gradlestaticanalyzer.internal.utils.JaxbUnmarshallerFactory;
import tech.kronicle.gradlestaticanalyzer.internal.utils.XmlInputFactoryFactory;
import tech.kronicle.sdk.models.SoftwareRepository;

public class ArtifactVersionsFetcher {
    private final MavenRepositoryFileDownloader mavenRepositoryFileDownloader;
    private final ArtifactUtils artifactUtils;
    private final Unmarshaller unmarshaller = JaxbUnmarshallerFactory.createJaxbUnmarshaller(Metadata.class);
    private final XMLInputFactory xmlInputFactory = XmlInputFactoryFactory.createXmlInputFactory();

    public List<String> fetchArtifactVersions(String groupId, String artifactId, Set<SoftwareRepository> softwareRepositories) {
        MavenRepositoryFileDownloader.MavenFileRequestOutcome<String> xmlContent = this.mavenRepositoryFileDownloader.downloadMetadata(groupId, artifactId, softwareRepositories);
        if (xmlContent.isFailure()) {
            throw new IllegalArgumentException("Could not retrieve maven metadata file for artifact coordinates \"" + StringEscapeUtils.escapeString((String)this.artifactUtils.createName(groupId, artifactId)) + "\" from safe subset of configured repositories");
        }
        Metadata metadata = this.readMetadataXml(xmlContent.getOutput());
        return Optional.of(metadata).map(Metadata::getVersioning).map(Versioning::getVersions).map(Versions::getVersions).orElseGet(List::of);
    }

    private Metadata readMetadataXml(String content) {
        try {
            return (Metadata)this.unmarshaller.unmarshal(this.xmlInputFactory.createXMLStreamReader(new StringReader(content)));
        }
        catch (JAXBException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public ArtifactVersionsFetcher(MavenRepositoryFileDownloader mavenRepositoryFileDownloader, ArtifactUtils artifactUtils) {
        this.mavenRepositoryFileDownloader = mavenRepositoryFileDownloader;
        this.artifactUtils = artifactUtils;
    }
}

