/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor;

import java.util.Objects;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.BaseVisitor;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.BaseVisitorDependencies;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.ExtVisitor;

public class ExtOuterVisitor
extends BaseVisitor {
    private static final Logger log = LoggerFactory.getLogger(ExtOuterVisitor.class);
    private final ExtVisitor extVisitor;

    public ExtOuterVisitor(BaseVisitorDependencies dependencies, ExtVisitor extVisitor) {
        super(dependencies);
        this.extVisitor = extVisitor;
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        String objectName;
        Expression objectExpression = call.getObjectExpression();
        if (objectExpression instanceof VariableExpression && (Objects.equals(objectName = ((VariableExpression)objectExpression).getName(), "this") || Objects.equals(objectName, "project"))) {
            log.debug("Found {}.ext", (Object)objectName);
            this.visit(call.getArguments(), this.extVisitor);
            return ExpressionVisitOutcome.PROCESSED;
        }
        return ExpressionVisitOutcome.IGNORED;
    }
}

