/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.schedule.impl;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.harmonysoft.oss.common.schedule.ScheduledTask;
import tech.harmonysoft.oss.common.schedule.TaskScheduler;
import tech.harmonysoft.oss.common.time.clock.ClockProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0012J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J1\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\"J0\u0010#\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltech/harmonysoft/oss/common/schedule/impl/TaskSchedulerImpl;", "Ltech/harmonysoft/oss/common/schedule/TaskScheduler;", "schedulerId", "", "clockProvider", "Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "threadPool", "Ljava/util/concurrent/ScheduledExecutorService;", "(Ljava/lang/String;Ltech/harmonysoft/oss/common/time/clock/ClockProvider;Ljava/util/concurrent/ScheduledExecutorService;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pending", "", "Ljava/util/concurrent/Future;", "pendingTasksLock", "Ljava/util/concurrent/locks/ReentrantLock;", "cleanStaleTasks", "", "activeTaskIds", "", "clear", "runTask", "task", "Ltech/harmonysoft/oss/common/schedule/ScheduledTask;", "anchorTimeMillis", "", "callback", "Ltech/harmonysoft/oss/common/schedule/TaskScheduler$Callback;", "schedule", "tasks", "", "reschedule", "", "(Ltech/harmonysoft/oss/common/schedule/ScheduledTask;Ltech/harmonysoft/oss/common/schedule/TaskScheduler$Callback;ZLjava/lang/Long;)V", "scheduleTaskWithDelay", "delayMs", "nextTriggerTime", "harmonysoft-common"})
@SourceDebugExtension(value={"SMAP\nTaskSchedulerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskSchedulerImpl.kt\ntech/harmonysoft/oss/common/schedule/impl/TaskSchedulerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1549#2:156\n1620#2,3:157\n*S KotlinDebug\n*F\n+ 1 TaskSchedulerImpl.kt\ntech/harmonysoft/oss/common/schedule/impl/TaskSchedulerImpl\n*L\n28#1:156\n28#1:157,3\n*E\n"})
public final class TaskSchedulerImpl
implements TaskScheduler {
    @NotNull
    private final String schedulerId;
    @NotNull
    private final ClockProvider clockProvider;
    @NotNull
    private final ScheduledExecutorService threadPool;
    @NotNull
    private final Map<String, Future<?>> pending;
    @NotNull
    private final ReentrantLock pendingTasksLock;
    private final Logger logger;

    public TaskSchedulerImpl(@NotNull String schedulerId, @NotNull ClockProvider clockProvider, @NotNull ScheduledExecutorService threadPool) {
        Intrinsics.checkNotNullParameter((Object)schedulerId, (String)"schedulerId");
        Intrinsics.checkNotNullParameter((Object)clockProvider, (String)"clockProvider");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        this.schedulerId = schedulerId;
        this.clockProvider = clockProvider;
        this.threadPool = threadPool;
        this.pending = new LinkedHashMap();
        this.pendingTasksLock = new ReentrantLock();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void schedule(@NotNull Collection<ScheduledTask> tasks, @NotNull TaskScheduler.Callback callback) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.logger.info("Got a request to apply new tasks schedule for {}: {}", (Object)this.schedulerId, tasks);
        Iterable iterable = tasks;
        TaskSchedulerImpl taskSchedulerImpl = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScheduledTask scheduledTask = (ScheduledTask)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        taskSchedulerImpl.cleanStaleTasks(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        for (ScheduledTask task : tasks) {
            TaskSchedulerImpl.schedule$default(this, task, callback, false, null, 8, null);
        }
    }

    private final synchronized void schedule(ScheduledTask task, TaskScheduler.Callback callback, boolean reschedule, Long anchorTimeMillis) {
        Object object = this.clockProvider.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        Clock clock = (Clock)object;
        long now = clock.millis();
        Long l = anchorTimeMillis;
        Date nextTriggerTime = task.getSchedule().getNextValidTimeAfter(new Date((l != null ? l : now) + 1L));
        this.scheduleTaskWithDelay(task, nextTriggerTime.getTime() - now, nextTriggerTime.getTime(), reschedule, callback);
    }

    static /* synthetic */ void schedule$default(TaskSchedulerImpl taskSchedulerImpl, ScheduledTask scheduledTask, TaskScheduler.Callback callback, boolean bl, Long l, int n, Object object) {
        if ((n & 8) != 0) {
            l = null;
        }
        taskSchedulerImpl.schedule(scheduledTask, callback, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void scheduleTaskWithDelay(ScheduledTask task, long delayMs, long nextTriggerTime, boolean reschedule, TaskScheduler.Callback callback) {
        Lock lock = this.pendingTasksLock;
        lock.lock();
        try {
            boolean bl = false;
            Future<?> previous = this.pending.remove(task.getId());
            if (previous == null && reschedule) {
                return;
            }
            Future<?> future = previous;
            if (future != null) {
                future.cancel(false);
            }
            Object[] objectArray = new Object[]{task.getId(), this.schedulerId, delayMs, LocalDateTime.now((Clock)this.clockProvider.getData()).plus(delayMs, ChronoField.MILLI_OF_DAY.getBaseUnit())};
            this.logger.info("Scheduling task '{}' to run by scheduler {} in {} ms (at {})", objectArray);
            ScheduledFuture<?> future2 = this.threadPool.schedule(() -> TaskSchedulerImpl.scheduleTaskWithDelay$lambda$2$lambda$1(this, task, nextTriggerTime, callback), delayMs, TimeUnit.MILLISECONDS);
            String string = task.getId();
            Intrinsics.checkNotNull(future2);
            this.pending.put(string, future2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runTask(ScheduledTask task, long anchorTimeMillis, TaskScheduler.Callback callback) {
        long now = ((Clock)this.clockProvider.getData()).millis();
        long delay = anchorTimeMillis - now;
        if (delay > 0L) {
            Object[] objectArray = new Object[]{task.getId(), this.schedulerId, now, anchorTimeMillis};
            this.logger.info("Task '{}' in scheduler {} is triggered before the target trigger time, now: {}, anchor time: {}, will re-schedule", objectArray);
            this.scheduleTaskWithDelay(task, delay, anchorTimeMillis, true, callback);
            return;
        }
        this.logger.info("Task '{}' is triggered by scheduler {}", (Object)task.getId(), (Object)this.schedulerId);
        try {
            callback.onTriggered(task.getId());
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{task.getId(), this.schedulerId, e};
            this.logger.warn("Got an unexpected exception on attempt to process task '{}' by scheduler {}", objectArray);
        }
        finally {
            this.schedule(task, callback, true, anchorTimeMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Set $i$a$-withLock-TaskSchedulerImpl$clear$tasks$22;
        Lock lock = this.pendingTasksLock;
        lock.lock();
        try {
            Set set;
            boolean $i$a$-withLock-TaskSchedulerImpl$clear$tasks$22 = false;
            Set $this$clear_u24lambda_u244_u24lambda_u243 = set = CollectionsKt.toSet((Iterable)this.pending.values());
            boolean bl = false;
            this.pending.clear();
            $i$a$-withLock-TaskSchedulerImpl$clear$tasks$22 = set;
        }
        finally {
            lock.unlock();
        }
        Set tasks = $i$a$-withLock-TaskSchedulerImpl$clear$tasks$22;
        for (Future task : tasks) {
            task.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanStaleTasks(Set<String> activeTaskIds) {
        Lock lock = this.pendingTasksLock;
        lock.lock();
        try {
            boolean bl = false;
            Set taskIds = CollectionsKt.toSet((Iterable)this.pending.keySet());
            for (String taskId : taskIds) {
                Future<?> future;
                if (activeTaskIds.contains(taskId)) continue;
                Object[] objectArray = new Object[]{taskId, this.schedulerId, activeTaskIds};
                this.logger.info("Cancelling stale task '{}' in scheduler {} as the task is not in the new schedule ({})", objectArray);
                if (this.pending.remove(taskId) == null) continue;
                Future<?> $this$cleanStaleTasks_u24lambda_u246_u24lambda_u245 = future;
                boolean bl2 = false;
                $this$cleanStaleTasks_u24lambda_u246_u24lambda_u245.cancel(false);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private static final void scheduleTaskWithDelay$lambda$2$lambda$1(TaskSchedulerImpl this$0, ScheduledTask $task, long $nextTriggerTime, TaskScheduler.Callback $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        this$0.runTask($task, $nextTriggerTime, $callback);
    }
}

