/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.schedule.impl;

import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.common.time.schedule.impl.LocalDateTimeProcessingStrategy;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001e"}, d2={"Ltech/harmonysoft/oss/common/time/schedule/impl/TimeWindow;", "", "startTime", "Ljava/time/LocalTime;", "endTime", "(Ljava/time/LocalTime;Ljava/time/LocalTime;)V", "getEndTime", "()Ljava/time/LocalTime;", "endTimeDayOffsetMillis", "", "getEndTimeDayOffsetMillis", "()J", "getStartTime", "startTimeDayOffsetMillis", "getStartTimeDayOffsetMillis", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "inWindow", "localTime", "dayTimeOffsetMilis", "overlaps", "toString", "", "Companion", "harmonysoft-common"})
public final class TimeWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalTime startTime;
    @NotNull
    private final LocalTime endTime;
    private final long startTimeDayOffsetMillis;
    private final long endTimeDayOffsetMillis;
    @NotNull
    public static final String END_OF_DAY = "<EOD>";
    @NotNull
    private static final Regex TIME_RANGE_REGEX = new Regex("\\s*([^-\\s]+)\\s*-\\s*([^\\\\s]+)");

    public TimeWindow(@NotNull LocalTime startTime, @NotNull LocalTime endTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        this.startTime = startTime;
        this.endTime = endTime;
        this.startTimeDayOffsetMillis = LocalDateTimeProcessingStrategy.INSTANCE.timeMsFromStartOfTheDay(this.startTime);
        this.endTimeDayOffsetMillis = LocalDateTimeProcessingStrategy.INSTANCE.timeMsFromStartOfTheDay(this.endTime);
        if (!this.startTime.isBefore(this.endTime)) {
            throw new IllegalArgumentException("detected an attempt to use a " + Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + " where start time (" + this.startTime + ") is not before end time (" + this.endTime + ')');
        }
    }

    @NotNull
    public final LocalTime getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final LocalTime getEndTime() {
        return this.endTime;
    }

    public final long getStartTimeDayOffsetMillis() {
        return this.startTimeDayOffsetMillis;
    }

    public final long getEndTimeDayOffsetMillis() {
        return this.endTimeDayOffsetMillis;
    }

    public final boolean inWindow(@NotNull LocalTime localTime) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        return !localTime.isBefore(this.startTime) && !localTime.isAfter(this.endTime);
    }

    public final boolean inWindow(long dayTimeOffsetMilis) {
        return dayTimeOffsetMilis >= this.startTimeDayOffsetMillis && dayTimeOffsetMilis <= this.endTimeDayOffsetMillis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean overlaps(@NotNull TimeWindow other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LocalTime localTime = this.startTime.plusSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"startTime.plusSeconds(1)");
        if (other.inWindow(localTime)) return true;
        LocalTime localTime2 = this.endTime.minusSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"endTime.minusSeconds(1)");
        if (!other.inWindow(localTime2)) return false;
        return true;
    }

    @NotNull
    public final LocalTime component1() {
        return this.startTime;
    }

    @NotNull
    public final LocalTime component2() {
        return this.endTime;
    }

    @NotNull
    public final TimeWindow copy(@NotNull LocalTime startTime, @NotNull LocalTime endTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return new TimeWindow(startTime, endTime);
    }

    public static /* synthetic */ TimeWindow copy$default(TimeWindow timeWindow, LocalTime localTime, LocalTime localTime2, int n, Object object) {
        if ((n & 1) != 0) {
            localTime = timeWindow.startTime;
        }
        if ((n & 2) != 0) {
            localTime2 = timeWindow.endTime;
        }
        return timeWindow.copy(localTime, localTime2);
    }

    @NotNull
    public String toString() {
        return "TimeWindow(startTime=" + this.startTime + ", endTime=" + this.endTime + ')';
    }

    public int hashCode() {
        int result = this.startTime.hashCode();
        result = result * 31 + this.endTime.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimeWindow)) {
            return false;
        }
        TimeWindow timeWindow = (TimeWindow)other;
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)timeWindow.startTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endTime, (Object)timeWindow.endTime);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltech/harmonysoft/oss/common/time/schedule/impl/TimeWindow$Companion;", "", "()V", "END_OF_DAY", "", "TIME_RANGE_REGEX", "Lkotlin/text/Regex;", "parse", "Ltech/harmonysoft/oss/common/time/schedule/impl/TimeWindow;", "timeWindowString", "harmonysoft-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeWindow parse(@NotNull String timeWindowString) {
            Pair pair;
            block5: {
                block4: {
                    Pair pair2;
                    MatchResult.Destructured destructured;
                    Intrinsics.checkNotNullParameter((Object)timeWindowString, (String)"timeWindowString");
                    MatchResult matchResult = TIME_RANGE_REGEX.matchEntire((CharSequence)timeWindowString);
                    if (matchResult == null || (destructured = matchResult.getDestructured()) == null) break block4;
                    MatchResult.Destructured destructured2 = destructured;
                    boolean bl = false;
                    String start = (String)destructured2.getMatch().getGroupValues().get(1);
                    String end = (String)destructured2.getMatch().getGroupValues().get(2);
                    try {
                        LocalTime endTime = Intrinsics.areEqual((Object)end, (Object)TimeWindow.END_OF_DAY) ? LocalTime.MAX : LocalTime.parse(end);
                        pair2 = TuplesKt.to((Object)LocalTime.parse(start), (Object)endTime);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("failed to parse time window. Start time string: '" + start + "', end time string: '" + end + '\'', e);
                    }
                    pair = pair2;
                    if (pair != null) break block5;
                }
                throw new IllegalArgumentException("failed to parse time window from '" + timeWindowString + '\'');
            }
            Pair pair3 = pair;
            LocalTime start = (LocalTime)pair3.component1();
            LocalTime end = (LocalTime)pair3.component2();
            Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
            Intrinsics.checkNotNullExpressionValue((Object)end, (String)"end");
            return new TimeWindow(start, end);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

