/*
 * Decompiled with CFR 0.152.
 */
package tech.gusavila92.websocketclient;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import tech.gusavila92.apache.commons.codec.binary.Base64;
import tech.gusavila92.apache.commons.codec.digest.DigestUtils;
import tech.gusavila92.apache.http.Header;
import tech.gusavila92.apache.http.HttpException;
import tech.gusavila92.apache.http.HttpResponse;
import tech.gusavila92.apache.http.StatusLine;
import tech.gusavila92.apache.http.impl.io.DefaultHttpResponseParser;
import tech.gusavila92.apache.http.impl.io.HttpTransportMetricsImpl;
import tech.gusavila92.apache.http.impl.io.SessionInputBufferImpl;
import tech.gusavila92.websocketclient.common.Utils;
import tech.gusavila92.websocketclient.exceptions.IllegalSchemeException;
import tech.gusavila92.websocketclient.exceptions.InvalidServerHandshakeException;
import tech.gusavila92.websocketclient.exceptions.UnknownOpcodeException;
import tech.gusavila92.websocketclient.model.Payload;

public abstract class WebSocketClient {
    private static final String GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final int OPCODE_CONTINUATION = 0;
    private static final int OPCODE_TEXT = 1;
    private static final int OPCODE_BINARY = 2;
    private static final int OPCODE_CLOSE = 8;
    private static final int OPCODE_PING = 9;
    private static final int OPCODE_PONG = 10;
    private final URI uri;
    private final Map<String, String> headers;
    private final Thread writerThread;
    private volatile boolean pendingMessages;
    private volatile boolean isClosed;
    private final LinkedList<Payload> outBuffer;
    private final SecureRandom secureRandom;
    private final Object lock;
    private Socket socket;
    private BufferedInputStream bis;
    private BufferedOutputStream bos;

    public WebSocketClient(URI uri, Map<String, String> headers) {
        this.uri = uri;
        this.headers = headers;
        this.pendingMessages = false;
        this.isClosed = false;
        this.outBuffer = new LinkedList();
        this.secureRandom = new SecureRandom();
        this.lock = new Object();
        this.writerThread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Object object = WebSocketClient.this.lock;
                synchronized (object) {
                    block6: while (true) {
                        if (!WebSocketClient.this.pendingMessages) {
                            try {
                                WebSocketClient.this.lock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        WebSocketClient.this.pendingMessages = false;
                        if (WebSocketClient.this.socket.isClosed()) {
                            return;
                        }
                        while (true) {
                            if (WebSocketClient.this.outBuffer.size() <= 0) continue block6;
                            Payload payload = (Payload)WebSocketClient.this.outBuffer.poll();
                            int opcode = payload.getOpcode();
                            byte[] data = payload.getData();
                            try {
                                WebSocketClient.this.send(opcode, data);
                            }
                            catch (IOException e) {
                                return;
                            }
                        }
                        break;
                    }
                }
            }
        });
    }

    public abstract void onOpen();

    public abstract void onTextReceived(String var1);

    public abstract void onBinaryReceived(byte[] var1);

    public abstract void onPingReceived(byte[] var1);

    public abstract void onPongReceived();

    public abstract void onException(Exception var1);

    public abstract void onCloseReceived();

    public void connectAsync() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebSocketClient.this.connect();
            }
        }).start();
    }

    public void connectBlocking() {
        this.connect();
    }

    public void send(String message) {
        byte[] data = message.getBytes(Charset.forName("UTF-8"));
        final Payload payload = new Payload(1, data);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = WebSocketClient.this.lock;
                synchronized (object) {
                    WebSocketClient.this.outBuffer.add(payload);
                    WebSocketClient.this.pendingMessages = true;
                    WebSocketClient.this.lock.notify();
                }
            }
        }).start();
    }

    public void send(byte[] data) {
        final Payload payload = new Payload(2, data);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = WebSocketClient.this.lock;
                synchronized (object) {
                    WebSocketClient.this.outBuffer.add(payload);
                    WebSocketClient.this.pendingMessages = true;
                    WebSocketClient.this.lock.notify();
                }
            }
        }).start();
    }

    public void close() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebSocketClient.this.closeInternal();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        try {
            boolean success = this.createAndConnectTCPSocket();
            if (success) {
                this.startConnection();
            }
        }
        catch (Exception e) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isClosed) {
                    this.onException(e);
                }
            }
            this.closeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean createAndConnectTCPSocket() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                String scheme = this.uri.getScheme();
                int port = this.uri.getPort();
                if (scheme == null) throw new IllegalSchemeException("The scheme component of the URI cannot be null");
                if (scheme.equals("ws")) {
                    SocketFactory socketFactory = SocketFactory.getDefault();
                    this.socket = socketFactory.createSocket();
                    if (port != -1) {
                        this.socket.connect(new InetSocketAddress(this.uri.getHost(), port));
                    } else {
                        this.socket.connect(new InetSocketAddress(this.uri.getHost(), 80));
                    }
                } else {
                    if (!scheme.equals("wss")) throw new IllegalSchemeException("The scheme component of the URI should be ws or wss");
                    SSLSocketFactory socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    this.socket = socketFactory.createSocket();
                    if (port != -1) {
                        this.socket.connect(new InetSocketAddress(this.uri.getHost(), port));
                    } else {
                        this.socket.connect(new InetSocketAddress(this.uri.getHost(), 443));
                    }
                }
                return true;
            }
            return false;
        }
    }

    private void startConnection() throws IOException {
        this.bos = new BufferedOutputStream(this.socket.getOutputStream(), 65536);
        byte[] key = new byte[16];
        Random random = new Random();
        random.nextBytes(key);
        String base64Key = Base64.encodeBase64String(key);
        byte[] handshake = this.createHandshake(base64Key);
        this.bos.write(handshake);
        this.bos.flush();
        InputStream inputStream = this.socket.getInputStream();
        this.verifyServerHandshake(inputStream, base64Key);
        this.writerThread.start();
        this.onOpen();
        this.bis = new BufferedInputStream(this.socket.getInputStream(), 65536);
        this.read();
    }

    private byte[] createHandshake(String base64Key) {
        StringBuilder builder = new StringBuilder();
        String path = this.uri.getRawPath();
        String query = this.uri.getRawQuery();
        String requestUri = query == null ? path : path + "?" + query;
        builder.append("GET " + requestUri + " HTTP/1.1");
        builder.append("\r\n");
        String host = this.uri.getPort() == -1 ? this.uri.getHost() : this.uri.getHost() + ":" + this.uri.getPort();
        builder.append("Host: " + host);
        builder.append("\r\n");
        builder.append("Upgrade: websocket");
        builder.append("\r\n");
        builder.append("Connection: Upgrade");
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Key: " + base64Key);
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Version: 13");
        builder.append("\r\n");
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.append(entry.getKey() + ": " + entry.getValue());
                builder.append("\r\n");
            }
        }
        builder.append("\r\n");
        String handshake = builder.toString();
        return handshake.getBytes(Charset.forName("ASCII"));
    }

    private void verifyServerHandshake(InputStream inputStream, String secWebSocketKey) throws IOException {
        try {
            SessionInputBufferImpl sessionInputBuffer = new SessionInputBufferImpl(new HttpTransportMetricsImpl(), 8192);
            sessionInputBuffer.bind(inputStream);
            DefaultHttpResponseParser parser = new DefaultHttpResponseParser(sessionInputBuffer);
            HttpResponse response = (HttpResponse)parser.parse();
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                throw new InvalidServerHandshakeException("There is no status line");
            }
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 101) {
                throw new InvalidServerHandshakeException("Invalid status code. Expected 101, received: " + statusCode);
            }
            Header[] upgradeHeader = response.getHeaders("Upgrade");
            if (upgradeHeader.length == 0) {
                throw new InvalidServerHandshakeException("There is no header named Upgrade");
            }
            String upgradeValue = upgradeHeader[0].getValue();
            if (upgradeValue == null) {
                throw new InvalidServerHandshakeException("There is no value for header Upgrade");
            }
            if (!(upgradeValue = upgradeValue.toLowerCase()).equals("websocket")) {
                throw new InvalidServerHandshakeException("Invalid value for header Upgrade. Expected: websocket, received: " + upgradeValue);
            }
            Header[] connectionHeader = response.getHeaders("Connection");
            if (connectionHeader.length == 0) {
                throw new InvalidServerHandshakeException("There is no header named Connection");
            }
            String connectionValue = connectionHeader[0].getValue();
            if (connectionValue == null) {
                throw new InvalidServerHandshakeException("There is no value for header Connection");
            }
            if (!(connectionValue = connectionValue.toLowerCase()).equals("upgrade")) {
                throw new InvalidServerHandshakeException("Invalid value for header Connection. Expected: upgrade, received: " + connectionValue);
            }
            Header[] secWebSocketAcceptHeader = response.getHeaders("Sec-WebSocket-Accept");
            if (secWebSocketAcceptHeader.length == 0) {
                throw new InvalidServerHandshakeException("There is no header named Sec-WebSocket-Accept");
            }
            String secWebSocketAcceptValue = secWebSocketAcceptHeader[0].getValue();
            if (secWebSocketAcceptValue == null) {
                throw new InvalidServerHandshakeException("There is no value for header Sec-WebSocket-Accept");
            }
            String keyConcatenation = secWebSocketKey + GUID;
            byte[] sha1 = DigestUtils.sha1(keyConcatenation);
            String secWebSocketAccept = Base64.encodeBase64String(sha1);
            if (!secWebSocketAcceptValue.equals(secWebSocketAccept)) {
                throw new InvalidServerHandshakeException("Invalid value for header Sec-WebSocket-Accept. Expected: " + secWebSocketAccept + ", received: " + secWebSocketAcceptValue);
            }
        }
        catch (HttpException e) {
            throw new InvalidServerHandshakeException(e.getMessage());
        }
    }

    private void send(int opcode, byte[] payload) throws IOException {
        byte[] array;
        int nextPosition;
        byte[] frame;
        int length = payload.length;
        if (length < 126) {
            frame = new byte[6 + length];
            frame[0] = (byte)(0xFFFFFF80 | opcode);
            frame[1] = (byte)(0xFFFFFF80 | length);
            nextPosition = 2;
        } else if (length < 65536) {
            frame = new byte[8 + length];
            frame[0] = (byte)(0xFFFFFF80 | opcode);
            frame[1] = -2;
            array = Utils.to2ByteArray(length);
            frame[2] = array[0];
            frame[3] = array[1];
            nextPosition = 4;
        } else {
            frame = new byte[14 + length];
            frame[0] = (byte)(0xFFFFFF80 | opcode);
            frame[1] = -1;
            array = Utils.to8ByteArray(length);
            frame[2] = array[0];
            frame[3] = array[1];
            frame[4] = array[2];
            frame[5] = array[3];
            frame[6] = array[4];
            frame[7] = array[5];
            frame[8] = array[6];
            frame[9] = array[7];
            nextPosition = 10;
        }
        byte[] mask = new byte[4];
        this.secureRandom.nextBytes(mask);
        frame[nextPosition] = mask[0];
        frame[nextPosition + 1] = mask[1];
        frame[nextPosition + 2] = mask[2];
        frame[nextPosition + 3] = mask[3];
        nextPosition += 4;
        for (int i = 0; i < length; ++i) {
            frame[nextPosition] = (byte)(payload[i] ^ mask[i % 4]);
            ++nextPosition;
        }
        this.bos.write(frame);
        this.bos.flush();
    }

    private void read() throws IOException {
        int firstByte;
        block8: while ((firstByte = this.bis.read()) != -1) {
            byte b;
            int i;
            int opcode = firstByte << 28 >>> 28;
            int secondByte = this.bis.read();
            if (secondByte == -1) {
                throw new IOException("Unexpected end of stream");
            }
            int payloadLength = secondByte << 25 >>> 25;
            if (payloadLength == 126) {
                byte[] nextTwoBytes = new byte[2];
                for (i = 0; i < 2; ++i) {
                    b = (byte)this.bis.read();
                    if (b == -1) {
                        throw new IOException("Unexpected end of stream");
                    }
                    nextTwoBytes[i] = b;
                }
                byte[] integer = new byte[]{0, 0, nextTwoBytes[0], nextTwoBytes[1]};
                payloadLength = Utils.fromByteArray(integer);
            } else if (payloadLength == 127) {
                byte[] nextEightBytes = new byte[8];
                for (i = 0; i < 8; ++i) {
                    b = (byte)this.bis.read();
                    if (b == -1) {
                        throw new IOException("Unexpected end of stream");
                    }
                    nextEightBytes[i] = b;
                }
                byte[] integer = new byte[]{nextEightBytes[4], nextEightBytes[5], nextEightBytes[6], nextEightBytes[7]};
                payloadLength = Utils.fromByteArray(integer);
            }
            byte[] data = new byte[payloadLength];
            for (i = 0; i < payloadLength; ++i) {
                b = (byte)this.bis.read();
                if (b == -1) {
                    throw new IOException("Unexpected end of stream");
                }
                data[i] = b;
            }
            switch (opcode) {
                case 0: {
                    continue block8;
                }
                case 1: {
                    this.onTextReceived(new String(data, Charset.forName("UTF-8")));
                    continue block8;
                }
                case 2: {
                    this.onBinaryReceived(data);
                    continue block8;
                }
                case 8: {
                    this.closeInternal();
                    this.onCloseReceived();
                    return;
                }
                case 9: {
                    this.onPingReceived(data);
                    continue block8;
                }
                case 10: {
                    this.onPongReceived();
                    continue block8;
                }
            }
            this.closeInternal();
            UnknownOpcodeException e = new UnknownOpcodeException("Unknown opcode: 0x" + Integer.toHexString(opcode));
            this.onException(e);
            return;
        }
        throw new IOException("Unexpected end of stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isClosed) {
                    this.isClosed = true;
                    if (this.socket != null) {
                        this.socket.close();
                        this.pendingMessages = true;
                        this.lock.notify();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

